/**
 * This file was auto-generated by Fern from our API Definition.
 */

package resources.decisions;

import com.fasterxml.jackson.core.JsonProcessingException;
import core.ClientOptions;
import core.ObjectMappers;
import core.QueryStringMapper;
import core.RequestOptions;
import core.RulebricksApiApiException;
import core.RulebricksApiException;
import errors.BadRequestError;
import errors.InternalServerError;
import java.io.IOException;
import java.lang.Object;
import java.lang.String;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import resources.decisions.requests.DecisionsQueryRequest;
import types.DecisionLogResponse;

public class DecisionsClient {
  protected final ClientOptions clientOptions;

  public DecisionsClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
  }

  /**
   * Retrieve logs for a specific user and rule, with optional date range and pagination.
   */
  public DecisionLogResponse query(DecisionsQueryRequest request) {
    return query(request,null);
  }

  /**
   * Retrieve logs for a specific user and rule, with optional date range and pagination.
   */
  public DecisionLogResponse query(DecisionsQueryRequest request, RequestOptions requestOptions) {
    HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

      .addPathSegments("decisions/query");QueryStringMapper.addQueryParameter(httpUrl, "slug", request.getSlug(), false);
      if (request.getFrom().isPresent()) {
        QueryStringMapper.addQueryParameter(httpUrl, "from", request.getFrom().get().toString(), false);
      }
      if (request.getTo().isPresent()) {
        QueryStringMapper.addQueryParameter(httpUrl, "to", request.getTo().get().toString(), false);
      }
      if (request.getCursor().isPresent()) {
        QueryStringMapper.addQueryParameter(httpUrl, "cursor", request.getCursor().get(), false);
      }
      if (request.getLimit().isPresent()) {
        QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get().toString(), false);
      }
      Request.Builder _requestBuilder = new Request.Builder()
        .url(httpUrl.build())
        .method("GET", null)
        .headers(Headers.of(clientOptions.headers(requestOptions)))
        .addHeader("Content-Type", "application/json")
        .addHeader("Accept", "application/json");
      Request okhttpRequest = _requestBuilder.build();
      OkHttpClient client = clientOptions.httpClient();
      if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
        client = clientOptions.httpClientWithTimeout(requestOptions);
      }
      try (Response response = client.newCall(okhttpRequest).execute()) {
        ResponseBody responseBody = response.body();
        if (response.isSuccessful()) {
          return ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), DecisionLogResponse.class);
        }
        String responseBodyString = responseBody != null ? responseBody.string() : "{}";
        try {
          switch (response.code()) {
            case 400:throw new BadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            case 500:throw new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
          }
        }
        catch (JsonProcessingException ignored) {
          // unable to map error response, throwing generic error
        }
        throw new RulebricksApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
      }
      catch (IOException e) {
        throw new RulebricksApiException("Network error executing HTTP request", e);
      }
    }
  }
