/**
 * This file was auto-generated by Fern from our API Definition.
 */

package resources.users.groups.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = CreateUserGroupRequest.Builder.class
)
public final class CreateUserGroupRequest {
  private final String name;

  private final Optional<String> description;

  private final Map<String, Object> additionalProperties;

  private CreateUserGroupRequest(String name, Optional<String> description,
      Map<String, Object> additionalProperties) {
    this.name = name;
    this.description = description;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Unique name of the user group.
   */
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  /**
   * @return Description of the user group.
   */
  @JsonProperty("description")
  public Optional<String> getDescription() {
    return description;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof CreateUserGroupRequest && equalTo((CreateUserGroupRequest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(CreateUserGroupRequest other) {
    return name.equals(other.name) && description.equals(other.description);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.name, this.description);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static NameStage builder() {
    return new Builder();
  }

  public interface NameStage {
    _FinalStage name(@NotNull String name);

    Builder from(CreateUserGroupRequest other);
  }

  public interface _FinalStage {
    CreateUserGroupRequest build();

    _FinalStage description(Optional<String> description);

    _FinalStage description(String description);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements NameStage, _FinalStage {
    private String name;

    private Optional<String> description = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(CreateUserGroupRequest other) {
      name(other.getName());
      description(other.getDescription());
      return this;
    }

    /**
     * <p>Unique name of the user group.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("name")
    public _FinalStage name(@NotNull String name) {
      this.name = Objects.requireNonNull(name, "name must not be null");
      return this;
    }

    /**
     * <p>Description of the user group.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage description(String description) {
      this.description = Optional.ofNullable(description);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "description",
        nulls = Nulls.SKIP
    )
    public _FinalStage description(Optional<String> description) {
      this.description = description;
      return this;
    }

    @java.lang.Override
    public CreateUserGroupRequest build() {
      return new CreateUserGroupRequest(name, description, additionalProperties);
    }
  }
}
