/**
 * This file was auto-generated by Fern from our API Definition.
 */

package types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import core.ObjectMappers;
import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = DecisionLogDecision.Builder.class
)
public final class DecisionLogDecision {
  private final Optional<List<Map<String, DecisionLogDecisionConditionsItemValue>>> conditions;

  private final Optional<List<Integer>> successIdxs;

  private final Map<String, Object> additionalProperties;

  private DecisionLogDecision(
      Optional<List<Map<String, DecisionLogDecisionConditionsItemValue>>> conditions,
      Optional<List<Integer>> successIdxs, Map<String, Object> additionalProperties) {
    this.conditions = conditions;
    this.successIdxs = successIdxs;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("conditions")
  public Optional<List<Map<String, DecisionLogDecisionConditionsItemValue>>> getConditions() {
    return conditions;
  }

  @JsonProperty("successIdxs")
  public Optional<List<Integer>> getSuccessIdxs() {
    return successIdxs;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof DecisionLogDecision && equalTo((DecisionLogDecision) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(DecisionLogDecision other) {
    return conditions.equals(other.conditions) && successIdxs.equals(other.successIdxs);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.conditions, this.successIdxs);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<List<Map<String, DecisionLogDecisionConditionsItemValue>>> conditions = Optional.empty();

    private Optional<List<Integer>> successIdxs = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(DecisionLogDecision other) {
      conditions(other.getConditions());
      successIdxs(other.getSuccessIdxs());
      return this;
    }

    @JsonSetter(
        value = "conditions",
        nulls = Nulls.SKIP
    )
    public Builder conditions(
        Optional<List<Map<String, DecisionLogDecisionConditionsItemValue>>> conditions) {
      this.conditions = conditions;
      return this;
    }

    public Builder conditions(
        List<Map<String, DecisionLogDecisionConditionsItemValue>> conditions) {
      this.conditions = Optional.ofNullable(conditions);
      return this;
    }

    @JsonSetter(
        value = "successIdxs",
        nulls = Nulls.SKIP
    )
    public Builder successIdxs(Optional<List<Integer>> successIdxs) {
      this.successIdxs = successIdxs;
      return this;
    }

    public Builder successIdxs(List<Integer> successIdxs) {
      this.successIdxs = Optional.ofNullable(successIdxs);
      return this;
    }

    public DecisionLogDecision build() {
      return new DecisionLogDecision(conditions, successIdxs, additionalProperties);
    }
  }
}
