/**
 * This file was auto-generated by Fern from our API Definition.
 */

package types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Object;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;

public final class DynamicValue {
  private final Value value;

  @JsonCreator(
      mode = JsonCreator.Mode.DELEGATING
  )
  private DynamicValue(Value value) {
    this.value = value;
  }

  public <T> T visit(Visitor<T> visitor) {
    return value.visit(visitor);
  }

  public static DynamicValue string(types.StringValue value) {
    return new DynamicValue(new StringValue(value));
  }

  public static DynamicValue number(types.NumberValue value) {
    return new DynamicValue(new NumberValue(value));
  }

  public static DynamicValue boolean_(types.BooleanValue value) {
    return new DynamicValue(new BooleanValue(value));
  }

  public static DynamicValue list(types.ListValue value) {
    return new DynamicValue(new ListValue(value));
  }

  public boolean isString() {
    return value instanceof StringValue;
  }

  public boolean isNumber() {
    return value instanceof NumberValue;
  }

  public boolean isBoolean() {
    return value instanceof BooleanValue;
  }

  public boolean isList() {
    return value instanceof ListValue;
  }

  public boolean _isUnknown() {
    return value instanceof _UnknownValue;
  }

  public Optional<types.StringValue> getString() {
    if (isString()) {
      return Optional.of(((StringValue) value).value);
    }
    return Optional.empty();
  }

  public Optional<types.NumberValue> getNumber() {
    if (isNumber()) {
      return Optional.of(((NumberValue) value).value);
    }
    return Optional.empty();
  }

  public Optional<types.BooleanValue> getBoolean() {
    if (isBoolean()) {
      return Optional.of(((BooleanValue) value).value);
    }
    return Optional.empty();
  }

  public Optional<types.ListValue> getList() {
    if (isList()) {
      return Optional.of(((ListValue) value).value);
    }
    return Optional.empty();
  }

  public Optional<Object> _getUnknown() {
    if (_isUnknown()) {
      return Optional.of(((_UnknownValue) value).value);
    }
    return Optional.empty();
  }

  @JsonValue
  private Value getValue() {
    return this.value;
  }

  public interface Visitor<T> {
    T visitString(types.StringValue string);

    T visitNumber(types.NumberValue number);

    T visitBoolean(types.BooleanValue boolean_);

    T visitList(types.ListValue list);

    T _visitUnknown(Object unknownType);
  }

  @JsonTypeInfo(
      use = JsonTypeInfo.Id.NAME,
      property = "type",
      visible = true,
      defaultImpl = _UnknownValue.class
  )
  @JsonSubTypes({
      @JsonSubTypes.Type(StringValue.class),
      @JsonSubTypes.Type(NumberValue.class),
      @JsonSubTypes.Type(BooleanValue.class),
      @JsonSubTypes.Type(ListValue.class)
  })
  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  private interface Value {
    <T> T visit(Visitor<T> visitor);
  }

  @JsonTypeName("string")
  @JsonIgnoreProperties("type")
  private static final class StringValue implements Value {
    @JsonUnwrapped
    private types.StringValue value;

    @JsonCreator(
        mode = JsonCreator.Mode.PROPERTIES
    )
    private StringValue() {
    }

    private StringValue(types.StringValue value) {
      this.value = value;
    }

    @java.lang.Override
    public <T> T visit(Visitor<T> visitor) {
      return visitor.visitString(value);
    }

    @java.lang.Override
    public boolean equals(Object other) {
      if (this == other) return true;
      return other instanceof StringValue && equalTo((StringValue) other);
    }

    private boolean equalTo(StringValue other) {
      return value.equals(other.value);
    }

    @java.lang.Override
    public int hashCode() {
      return Objects.hash(this.value);
    }

    @java.lang.Override
    public String toString() {
      return "DynamicValue{" + "value: " + value + "}";
    }
  }

  @JsonTypeName("number")
  @JsonIgnoreProperties("type")
  private static final class NumberValue implements Value {
    @JsonUnwrapped
    private types.NumberValue value;

    @JsonCreator(
        mode = JsonCreator.Mode.PROPERTIES
    )
    private NumberValue() {
    }

    private NumberValue(types.NumberValue value) {
      this.value = value;
    }

    @java.lang.Override
    public <T> T visit(Visitor<T> visitor) {
      return visitor.visitNumber(value);
    }

    @java.lang.Override
    public boolean equals(Object other) {
      if (this == other) return true;
      return other instanceof NumberValue && equalTo((NumberValue) other);
    }

    private boolean equalTo(NumberValue other) {
      return value.equals(other.value);
    }

    @java.lang.Override
    public int hashCode() {
      return Objects.hash(this.value);
    }

    @java.lang.Override
    public String toString() {
      return "DynamicValue{" + "value: " + value + "}";
    }
  }

  @JsonTypeName("boolean")
  @JsonIgnoreProperties("type")
  private static final class BooleanValue implements Value {
    @JsonUnwrapped
    private types.BooleanValue value;

    @JsonCreator(
        mode = JsonCreator.Mode.PROPERTIES
    )
    private BooleanValue() {
    }

    private BooleanValue(types.BooleanValue value) {
      this.value = value;
    }

    @java.lang.Override
    public <T> T visit(Visitor<T> visitor) {
      return visitor.visitBoolean(value);
    }

    @java.lang.Override
    public boolean equals(Object other) {
      if (this == other) return true;
      return other instanceof BooleanValue && equalTo((BooleanValue) other);
    }

    private boolean equalTo(BooleanValue other) {
      return value.equals(other.value);
    }

    @java.lang.Override
    public int hashCode() {
      return Objects.hash(this.value);
    }

    @java.lang.Override
    public String toString() {
      return "DynamicValue{" + "value: " + value + "}";
    }
  }

  @JsonTypeName("list")
  @JsonIgnoreProperties("type")
  private static final class ListValue implements Value {
    @JsonUnwrapped
    private types.ListValue value;

    @JsonCreator(
        mode = JsonCreator.Mode.PROPERTIES
    )
    private ListValue() {
    }

    private ListValue(types.ListValue value) {
      this.value = value;
    }

    @java.lang.Override
    public <T> T visit(Visitor<T> visitor) {
      return visitor.visitList(value);
    }

    @java.lang.Override
    public boolean equals(Object other) {
      if (this == other) return true;
      return other instanceof ListValue && equalTo((ListValue) other);
    }

    private boolean equalTo(ListValue other) {
      return value.equals(other.value);
    }

    @java.lang.Override
    public int hashCode() {
      return Objects.hash(this.value);
    }

    @java.lang.Override
    public String toString() {
      return "DynamicValue{" + "value: " + value + "}";
    }
  }

  @JsonIgnoreProperties("type")
  private static final class _UnknownValue implements Value {
    private String type;

    @JsonValue
    private Object value;

    @JsonCreator(
        mode = JsonCreator.Mode.PROPERTIES
    )
    private _UnknownValue(@JsonProperty("value") Object value) {
    }

    @java.lang.Override
    public <T> T visit(Visitor<T> visitor) {
      return visitor._visitUnknown(value);
    }

    @java.lang.Override
    public boolean equals(Object other) {
      if (this == other) return true;
      return other instanceof _UnknownValue && equalTo((_UnknownValue) other);
    }

    private boolean equalTo(_UnknownValue other) {
      return type.equals(other.type) && value.equals(other.value);
    }

    @java.lang.Override
    public int hashCode() {
      return Objects.hash(this.type, this.value);
    }

    @java.lang.Override
    public String toString() {
      return "DynamicValue{" + "type: " + type + ", value: " + value + "}";
    }
  }
}
