/**
 * This file was auto-generated by Fern from our API Definition.
 */

package types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = UserGroup.Builder.class
)
public final class UserGroup {
  private final Optional<String> id;

  private final Optional<String> name;

  private final Optional<String> description;

  private final Optional<List<String>> members;

  private final Map<String, Object> additionalProperties;

  private UserGroup(Optional<String> id, Optional<String> name, Optional<String> description,
      Optional<List<String>> members, Map<String, Object> additionalProperties) {
    this.id = id;
    this.name = name;
    this.description = description;
    this.members = members;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Unique identifier of the user group.
   */
  @JsonProperty("id")
  public Optional<String> getId() {
    return id;
  }

  /**
   * @return Name of the user group.
   */
  @JsonProperty("name")
  public Optional<String> getName() {
    return name;
  }

  /**
   * @return Description of the user group.
   */
  @JsonProperty("description")
  public Optional<String> getDescription() {
    return description;
  }

  /**
   * @return List of member emails in the user group.
   */
  @JsonProperty("members")
  public Optional<List<String>> getMembers() {
    return members;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof UserGroup && equalTo((UserGroup) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(UserGroup other) {
    return id.equals(other.id) && name.equals(other.name) && description.equals(other.description) && members.equals(other.members);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.id, this.name, this.description, this.members);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> id = Optional.empty();

    private Optional<String> name = Optional.empty();

    private Optional<String> description = Optional.empty();

    private Optional<List<String>> members = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(UserGroup other) {
      id(other.getId());
      name(other.getName());
      description(other.getDescription());
      members(other.getMembers());
      return this;
    }

    @JsonSetter(
        value = "id",
        nulls = Nulls.SKIP
    )
    public Builder id(Optional<String> id) {
      this.id = id;
      return this;
    }

    public Builder id(String id) {
      this.id = Optional.ofNullable(id);
      return this;
    }

    @JsonSetter(
        value = "name",
        nulls = Nulls.SKIP
    )
    public Builder name(Optional<String> name) {
      this.name = name;
      return this;
    }

    public Builder name(String name) {
      this.name = Optional.ofNullable(name);
      return this;
    }

    @JsonSetter(
        value = "description",
        nulls = Nulls.SKIP
    )
    public Builder description(Optional<String> description) {
      this.description = description;
      return this;
    }

    public Builder description(String description) {
      this.description = Optional.ofNullable(description);
      return this;
    }

    @JsonSetter(
        value = "members",
        nulls = Nulls.SKIP
    )
    public Builder members(Optional<List<String>> members) {
      this.members = members;
      return this;
    }

    public Builder members(List<String> members) {
      this.members = Optional.ofNullable(members);
      return this;
    }

    public UserGroup build() {
      return new UserGroup(id, name, description, members, additionalProperties);
    }
  }
}
