/*
 * Decompiled with CFR 0.152.
 */
package resources.assets;

import core.ClientOptions;
import core.ObjectMappers;
import core.RequestOptions;
import core.RulebricksApiApiException;
import core.RulebricksApiException;
import core.Suppliers;
import java.io.IOException;
import java.util.function.Supplier;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import resources.assets.flows.FlowsClient;
import resources.assets.folders.FoldersClient;
import resources.assets.rules.RulesClient;
import types.UsageStatistics;

public class AssetsClient {
    protected final ClientOptions clientOptions;
    protected final Supplier<RulesClient> rulesClient;
    protected final Supplier<FlowsClient> flowsClient;
    protected final Supplier<FoldersClient> foldersClient;

    public AssetsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rulesClient = Suppliers.memoize(() -> new RulesClient(clientOptions));
        this.flowsClient = Suppliers.memoize(() -> new FlowsClient(clientOptions));
        this.foldersClient = Suppliers.memoize(() -> new FoldersClient(clientOptions));
    }

    public UsageStatistics getUsage() {
        return this.getUsage(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UsageStatistics getUsage(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("admin/usage").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                UsageStatistics usageStatistics = (UsageStatistics)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UsageStatistics.class);
                return usageStatistics;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new RulebricksApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new RulebricksApiException("Network error executing HTTP request", e);
        }
    }

    public RulesClient rules() {
        return this.rulesClient.get();
    }

    public FlowsClient flows() {
        return this.flowsClient.get();
    }

    public FoldersClient folders() {
        return this.foldersClient.get();
    }
}

