/*
 * Decompiled with CFR 0.152.
 */
package resources.values.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import core.ObjectMappers;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import resources.values.types.UpdateValuesRequestValuesValue;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateValuesRequest {
    private final Map<String, UpdateValuesRequestValuesValue> values;
    private final Optional<List<String>> accessGroups;
    private final Map<String, Object> additionalProperties;

    private UpdateValuesRequest(Map<String, UpdateValuesRequestValuesValue> values, Optional<List<String>> accessGroups, Map<String, Object> additionalProperties) {
        this.values = values;
        this.accessGroups = accessGroups;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="values")
    public Map<String, UpdateValuesRequestValuesValue> getValues() {
        return this.values;
    }

    @JsonProperty(value="accessGroups")
    public Optional<List<String>> getAccessGroups() {
        return this.accessGroups;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateValuesRequest && this.equalTo((UpdateValuesRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateValuesRequest other) {
        return this.values.equals(other.values) && this.accessGroups.equals(other.accessGroups);
    }

    public int hashCode() {
        return Objects.hash(this.values, this.accessGroups);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Map<String, UpdateValuesRequestValuesValue> values = new LinkedHashMap<String, UpdateValuesRequestValuesValue>();
        private Optional<List<String>> accessGroups = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(UpdateValuesRequest other) {
            this.values(other.getValues());
            this.accessGroups(other.getAccessGroups());
            return this;
        }

        @JsonSetter(value="values", nulls=Nulls.SKIP)
        public Builder values(Map<String, UpdateValuesRequestValuesValue> values) {
            this.values.clear();
            this.values.putAll(values);
            return this;
        }

        public Builder putAllValues(Map<String, UpdateValuesRequestValuesValue> values) {
            this.values.putAll(values);
            return this;
        }

        public Builder values(String key, UpdateValuesRequestValuesValue value) {
            this.values.put(key, value);
            return this;
        }

        @JsonSetter(value="accessGroups", nulls=Nulls.SKIP)
        public Builder accessGroups(Optional<List<String>> accessGroups) {
            this.accessGroups = accessGroups;
            return this;
        }

        public Builder accessGroups(List<String> accessGroups) {
            this.accessGroups = Optional.ofNullable(accessGroups);
            return this;
        }

        public UpdateValuesRequest build() {
            return new UpdateValuesRequest(this.values, this.accessGroups, this.additionalProperties);
        }
    }
}

