/*
 * Decompiled with CFR 0.152.
 */
package types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DecisionLogRequest {
    private final Optional<String> ip;
    private final Optional<String> method;
    private final Optional<String> name;
    private final Optional<String> endpoint;
    private final Optional<Map<String, List<String>>> params;
    private final Optional<Object> data;
    private final Map<String, Object> additionalProperties;

    private DecisionLogRequest(Optional<String> ip, Optional<String> method, Optional<String> name, Optional<String> endpoint, Optional<Map<String, List<String>>> params, Optional<Object> data, Map<String, Object> additionalProperties) {
        this.ip = ip;
        this.method = method;
        this.name = name;
        this.endpoint = endpoint;
        this.params = params;
        this.data = data;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="ip")
    public Optional<String> getIp() {
        return this.ip;
    }

    @JsonProperty(value="method")
    public Optional<String> getMethod() {
        return this.method;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="endpoint")
    public Optional<String> getEndpoint() {
        return this.endpoint;
    }

    @JsonProperty(value="params")
    public Optional<Map<String, List<String>>> getParams() {
        return this.params;
    }

    @JsonProperty(value="data")
    public Optional<Object> getData() {
        return this.data;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DecisionLogRequest && this.equalTo((DecisionLogRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DecisionLogRequest other) {
        return this.ip.equals(other.ip) && this.method.equals(other.method) && this.name.equals(other.name) && this.endpoint.equals(other.endpoint) && this.params.equals(other.params) && this.data.equals(other.data);
    }

    public int hashCode() {
        return Objects.hash(this.ip, this.method, this.name, this.endpoint, this.params, this.data);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> ip = Optional.empty();
        private Optional<String> method = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> endpoint = Optional.empty();
        private Optional<Map<String, List<String>>> params = Optional.empty();
        private Optional<Object> data = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(DecisionLogRequest other) {
            this.ip(other.getIp());
            this.method(other.getMethod());
            this.name(other.getName());
            this.endpoint(other.getEndpoint());
            this.params(other.getParams());
            this.data(other.getData());
            return this;
        }

        @JsonSetter(value="ip", nulls=Nulls.SKIP)
        public Builder ip(Optional<String> ip) {
            this.ip = ip;
            return this;
        }

        public Builder ip(String ip) {
            this.ip = Optional.ofNullable(ip);
            return this;
        }

        @JsonSetter(value="method", nulls=Nulls.SKIP)
        public Builder method(Optional<String> method) {
            this.method = method;
            return this;
        }

        public Builder method(String method) {
            this.method = Optional.ofNullable(method);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @JsonSetter(value="endpoint", nulls=Nulls.SKIP)
        public Builder endpoint(Optional<String> endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = Optional.ofNullable(endpoint);
            return this;
        }

        @JsonSetter(value="params", nulls=Nulls.SKIP)
        public Builder params(Optional<Map<String, List<String>>> params) {
            this.params = params;
            return this;
        }

        public Builder params(Map<String, List<String>> params) {
            this.params = Optional.ofNullable(params);
            return this;
        }

        @JsonSetter(value="data", nulls=Nulls.SKIP)
        public Builder data(Optional<Object> data) {
            this.data = data;
            return this;
        }

        public Builder data(Object data) {
            this.data = Optional.ofNullable(data);
            return this;
        }

        public DecisionLogRequest build() {
            return new DecisionLogRequest(this.ip, this.method, this.name, this.endpoint, this.params, this.data, this.additionalProperties);
        }
    }
}

