/*
 * Decompiled with CFR 0.152.
 */
package types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class FlowExecutionError {
    private final Optional<String> error;
    private final Optional<String> node;
    private final Optional<Map<String, Object>> details;
    private final Map<String, Object> additionalProperties;

    private FlowExecutionError(Optional<String> error, Optional<String> node, Optional<Map<String, Object>> details, Map<String, Object> additionalProperties) {
        this.error = error;
        this.node = node;
        this.details = details;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="error")
    public Optional<String> getError() {
        return this.error;
    }

    @JsonProperty(value="node")
    public Optional<String> getNode() {
        return this.node;
    }

    @JsonProperty(value="details")
    public Optional<Map<String, Object>> getDetails() {
        return this.details;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof FlowExecutionError && this.equalTo((FlowExecutionError)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(FlowExecutionError other) {
        return this.error.equals(other.error) && this.node.equals(other.node) && this.details.equals(other.details);
    }

    public int hashCode() {
        return Objects.hash(this.error, this.node, this.details);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> error = Optional.empty();
        private Optional<String> node = Optional.empty();
        private Optional<Map<String, Object>> details = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(FlowExecutionError other) {
            this.error(other.getError());
            this.node(other.getNode());
            this.details(other.getDetails());
            return this;
        }

        @JsonSetter(value="error", nulls=Nulls.SKIP)
        public Builder error(Optional<String> error) {
            this.error = error;
            return this;
        }

        public Builder error(String error) {
            this.error = Optional.ofNullable(error);
            return this;
        }

        @JsonSetter(value="node", nulls=Nulls.SKIP)
        public Builder node(Optional<String> node) {
            this.node = node;
            return this;
        }

        public Builder node(String node) {
            this.node = Optional.ofNullable(node);
            return this;
        }

        @JsonSetter(value="details", nulls=Nulls.SKIP)
        public Builder details(Optional<Map<String, Object>> details) {
            this.details = details;
            return this;
        }

        public Builder details(Map<String, Object> details) {
            this.details = Optional.ofNullable(details);
            return this;
        }

        public FlowExecutionError build() {
            return new FlowExecutionError(this.error, this.node, this.details, this.additionalProperties);
        }
    }
}

