/*
 * Decompiled with CFR 0.152.
 */
package types;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import core.ObjectMappers;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonDeserialize(using=Deserializer.class)
public final class SchemaFieldDefaultValue {
    private final Object value;
    private final int type;

    private SchemaFieldDefaultValue(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((String)this.value);
        }
        if (this.type == 1) {
            return visitor.visit((Double)this.value);
        }
        if (this.type == 2) {
            return visitor.visit((Boolean)this.value);
        }
        if (this.type == 3) {
            return visitor.visit((Map)this.value);
        }
        if (this.type == 4) {
            return visitor.visit((List)this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SchemaFieldDefaultValue && this.equalTo((SchemaFieldDefaultValue)other);
    }

    private boolean equalTo(SchemaFieldDefaultValue other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }

    public static SchemaFieldDefaultValue of(String value) {
        return new SchemaFieldDefaultValue(value, 0);
    }

    public static SchemaFieldDefaultValue of(double value) {
        return new SchemaFieldDefaultValue(value, 1);
    }

    public static SchemaFieldDefaultValue of(boolean value) {
        return new SchemaFieldDefaultValue(value, 2);
    }

    public static SchemaFieldDefaultValue of(Map<String, Object> value) {
        return new SchemaFieldDefaultValue(value, 3);
    }

    public static SchemaFieldDefaultValue of(List<Object> value) {
        return new SchemaFieldDefaultValue(value, 4);
    }

    static final class Deserializer
    extends StdDeserializer<SchemaFieldDefaultValue> {
        Deserializer() {
            super(SchemaFieldDefaultValue.class);
        }

        public SchemaFieldDefaultValue deserialize(JsonParser p, DeserializationContext context) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return SchemaFieldDefaultValue.of((String)ObjectMappers.JSON_MAPPER.convertValue(value, String.class));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (value instanceof Double) {
                    return SchemaFieldDefaultValue.of((Double)value);
                }
                if (value instanceof Boolean) {
                    return SchemaFieldDefaultValue.of((Boolean)value);
                }
                try {
                    return SchemaFieldDefaultValue.of((Map)ObjectMappers.JSON_MAPPER.convertValue(value, (TypeReference)new TypeReference<Map<String, Object>>(){}));
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    try {
                        return SchemaFieldDefaultValue.of((List)ObjectMappers.JSON_MAPPER.convertValue(value, (TypeReference)new TypeReference<List<Object>>(){}));
                    }
                    catch (IllegalArgumentException illegalArgumentException3) {
                        throw new JsonParseException(p, "Failed to deserialize");
                    }
                }
            }
        }
    }

    public static interface Visitor<T> {
        public T visit(String var1);

        public T visit(double var1);

        public T visit(boolean var1);

        public T visit(Map<String, Object> var1);

        public T visit(List<Object> var1);
    }
}

