/*
 * Decompiled with CFR 0.152.
 */
package types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import types.IDynamicValueBase;
import types.RuleUsage;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class StringValue
implements IDynamicValueBase {
    private final Optional<String> id;
    private final Optional<String> name;
    private final Optional<List<RuleUsage>> usages;
    private final Optional<List<String>> accessGroups;
    private final Optional<String> value;
    private final Map<String, Object> additionalProperties;

    private StringValue(Optional<String> id, Optional<String> name, Optional<List<RuleUsage>> usages, Optional<List<String>> accessGroups, Optional<String> value, Map<String, Object> additionalProperties) {
        this.id = id;
        this.name = name;
        this.usages = usages;
        this.accessGroups = accessGroups;
        this.value = value;
        this.additionalProperties = additionalProperties;
    }

    @Override
    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="usages")
    public Optional<List<RuleUsage>> getUsages() {
        return this.usages;
    }

    @Override
    @JsonProperty(value="accessGroups")
    public Optional<List<String>> getAccessGroups() {
        return this.accessGroups;
    }

    @JsonProperty(value="value")
    public Optional<String> getValue() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof StringValue && this.equalTo((StringValue)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(StringValue other) {
        return this.id.equals(other.id) && this.name.equals(other.name) && this.usages.equals(other.usages) && this.accessGroups.equals(other.accessGroups) && this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.usages, this.accessGroups, this.value);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<List<RuleUsage>> usages = Optional.empty();
        private Optional<List<String>> accessGroups = Optional.empty();
        private Optional<String> value = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(StringValue other) {
            this.id(other.getId());
            this.name(other.getName());
            this.usages(other.getUsages());
            this.accessGroups(other.getAccessGroups());
            this.value(other.getValue());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @JsonSetter(value="usages", nulls=Nulls.SKIP)
        public Builder usages(Optional<List<RuleUsage>> usages) {
            this.usages = usages;
            return this;
        }

        public Builder usages(List<RuleUsage> usages) {
            this.usages = Optional.ofNullable(usages);
            return this;
        }

        @JsonSetter(value="accessGroups", nulls=Nulls.SKIP)
        public Builder accessGroups(Optional<List<String>> accessGroups) {
            this.accessGroups = accessGroups;
            return this;
        }

        public Builder accessGroups(List<String> accessGroups) {
            this.accessGroups = Optional.ofNullable(accessGroups);
            return this;
        }

        @JsonSetter(value="value", nulls=Nulls.SKIP)
        public Builder value(Optional<String> value) {
            this.value = value;
            return this;
        }

        public Builder value(String value) {
            this.value = Optional.ofNullable(value);
            return this;
        }

        public StringValue build() {
            return new StringValue(this.id, this.name, this.usages, this.accessGroups, this.value, this.additionalProperties);
        }
    }
}

