/*
 * Decompiled with CFR 0.152.
 */
import core.ClientOptions;
import core.Suppliers;
import java.util.function.Supplier;
import resources.assets.AssetsClient;
import resources.decisions.DecisionsClient;
import resources.flows.FlowsClient;
import resources.rules.RulesClient;
import resources.tests.TestsClient;
import resources.users.UsersClient;
import resources.values.ValuesClient;

public class RulebricksApiClient {
    protected final ClientOptions clientOptions;
    protected final Supplier<RulesClient> rulesClient;
    protected final Supplier<FlowsClient> flowsClient;
    protected final Supplier<DecisionsClient> decisionsClient;
    protected final Supplier<UsersClient> usersClient;
    protected final Supplier<AssetsClient> assetsClient;
    protected final Supplier<ValuesClient> valuesClient;
    protected final Supplier<TestsClient> testsClient;

    public RulebricksApiClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rulesClient = Suppliers.memoize(() -> new RulesClient(clientOptions));
        this.flowsClient = Suppliers.memoize(() -> new FlowsClient(clientOptions));
        this.decisionsClient = Suppliers.memoize(() -> new DecisionsClient(clientOptions));
        this.usersClient = Suppliers.memoize(() -> new UsersClient(clientOptions));
        this.assetsClient = Suppliers.memoize(() -> new AssetsClient(clientOptions));
        this.valuesClient = Suppliers.memoize(() -> new ValuesClient(clientOptions));
        this.testsClient = Suppliers.memoize(() -> new TestsClient(clientOptions));
    }

    public RulesClient rules() {
        return this.rulesClient.get();
    }

    public FlowsClient flows() {
        return this.flowsClient.get();
    }

    public DecisionsClient decisions() {
        return this.decisionsClient.get();
    }

    public UsersClient users() {
        return this.usersClient.get();
    }

    public AssetsClient assets() {
        return this.assetsClient.get();
    }

    public ValuesClient values() {
        return this.valuesClient.get();
    }

    public TestsClient tests() {
        return this.testsClient.get();
    }

    public static RulebricksApiClientBuilder builder() {
        return new RulebricksApiClientBuilder();
    }
}

