/*
 * Decompiled with CFR 0.152.
 */
package resources.users;

import com.fasterxml.jackson.core.JsonProcessingException;
import core.ClientOptions;
import core.MediaTypes;
import core.ObjectMappers;
import core.RequestOptions;
import core.RulebricksApiApiException;
import core.RulebricksApiException;
import core.Suppliers;
import errors.BadRequestError;
import errors.InternalServerError;
import java.io.IOException;
import java.util.function.Supplier;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import resources.users.groups.GroupsClient;
import resources.users.requests.UserInviteRequest;
import types.UserInviteResponse;

public class UsersClient {
    protected final ClientOptions clientOptions;
    protected final Supplier<GroupsClient> groupsClient;

    public UsersClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.groupsClient = Suppliers.memoize(() -> new GroupsClient(clientOptions));
    }

    public UserInviteResponse invite(UserInviteRequest request) {
        return this.invite(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UserInviteResponse invite(UserInviteRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("admin/users/invite").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new RulebricksApiException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                UserInviteResponse userInviteResponse = (UserInviteResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UserInviteResponse.class);
                return userInviteResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 500: {
                        throw new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                }
                throw new RulebricksApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new RulebricksApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new RulebricksApiException("Network error executing HTTP request", e);
        }
    }

    public GroupsClient groups() {
        return this.groupsClient.get();
    }
}

