/*
 * Decompiled with CFR 0.152.
 */
package types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import types.DecisionLogDecisionConditionsItemValue;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DecisionLogDecision {
    private final Optional<List<Map<String, DecisionLogDecisionConditionsItemValue>>> conditions;
    private final Optional<List<Integer>> successIdxs;
    private final Map<String, Object> additionalProperties;

    private DecisionLogDecision(Optional<List<Map<String, DecisionLogDecisionConditionsItemValue>>> conditions, Optional<List<Integer>> successIdxs, Map<String, Object> additionalProperties) {
        this.conditions = conditions;
        this.successIdxs = successIdxs;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="conditions")
    public Optional<List<Map<String, DecisionLogDecisionConditionsItemValue>>> getConditions() {
        return this.conditions;
    }

    @JsonProperty(value="successIdxs")
    public Optional<List<Integer>> getSuccessIdxs() {
        return this.successIdxs;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DecisionLogDecision && this.equalTo((DecisionLogDecision)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DecisionLogDecision other) {
        return this.conditions.equals(other.conditions) && this.successIdxs.equals(other.successIdxs);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.successIdxs);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Map<String, DecisionLogDecisionConditionsItemValue>>> conditions = Optional.empty();
        private Optional<List<Integer>> successIdxs = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(DecisionLogDecision other) {
            this.conditions(other.getConditions());
            this.successIdxs(other.getSuccessIdxs());
            return this;
        }

        @JsonSetter(value="conditions", nulls=Nulls.SKIP)
        public Builder conditions(Optional<List<Map<String, DecisionLogDecisionConditionsItemValue>>> conditions) {
            this.conditions = conditions;
            return this;
        }

        public Builder conditions(List<Map<String, DecisionLogDecisionConditionsItemValue>> conditions) {
            this.conditions = Optional.ofNullable(conditions);
            return this;
        }

        @JsonSetter(value="successIdxs", nulls=Nulls.SKIP)
        public Builder successIdxs(Optional<List<Integer>> successIdxs) {
            this.successIdxs = successIdxs;
            return this;
        }

        public Builder successIdxs(List<Integer> successIdxs) {
            this.successIdxs = Optional.ofNullable(successIdxs);
            return this;
        }

        public DecisionLogDecision build() {
            return new DecisionLogDecision(this.conditions, this.successIdxs, this.additionalProperties);
        }
    }
}

