/**
 * This file was auto-generated by Fern from our API Definition.
 */

package resources.assets;

import core.ClientOptions;
import core.ObjectMappers;
import core.RequestOptions;
import core.RulebricksApiApiException;
import core.RulebricksApiException;
import core.Suppliers;
import java.io.IOException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import resources.assets.flows.AsyncFlowsClient;
import resources.assets.folders.AsyncFoldersClient;
import resources.assets.rules.AsyncRulesClient;
import types.UsageStatistics;

public class AsyncAssetsClient {
  protected final ClientOptions clientOptions;

  protected final Supplier<AsyncRulesClient> rulesClient;

  protected final Supplier<AsyncFlowsClient> flowsClient;

  protected final Supplier<AsyncFoldersClient> foldersClient;

  public AsyncAssetsClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
    this.rulesClient = Suppliers.memoize(() -> new AsyncRulesClient(clientOptions));
    this.flowsClient = Suppliers.memoize(() -> new AsyncFlowsClient(clientOptions));
    this.foldersClient = Suppliers.memoize(() -> new AsyncFoldersClient(clientOptions));
  }

  /**
   * Get the rule execution usage of your organization.
   */
  public CompletableFuture<UsageStatistics> getUsage() {
    return getUsage(null);
  }

  /**
   * Get the rule execution usage of your organization.
   */
  public CompletableFuture<UsageStatistics> getUsage(RequestOptions requestOptions) {
    HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

      .addPathSegments("admin/usage")
      .build();
    Request okhttpRequest = new Request.Builder()
      .url(httpUrl)
      .method("GET", null)
      .headers(Headers.of(clientOptions.headers(requestOptions)))
      .addHeader("Content-Type", "application/json")
      .addHeader("Accept", "application/json")
      .build();
    OkHttpClient client = clientOptions.httpClient();
    if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
      client = clientOptions.httpClientWithTimeout(requestOptions);
    }
    CompletableFuture<UsageStatistics> future = new CompletableFuture<>();
    client.newCall(okhttpRequest).enqueue(new Callback() {
      @Override
      public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
        try (ResponseBody responseBody = response.body()) {
          if (response.isSuccessful()) {
            future.complete(ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UsageStatistics.class));
            return;
          }
          String responseBodyString = responseBody != null ? responseBody.string() : "{}";
          future.completeExceptionally(new RulebricksApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class)));
          return;
        }
        catch (IOException e) {
          future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
        }
      }

      @Override
      public void onFailure(@NotNull Call call, @NotNull IOException e) {
        future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
      }
    });
    return future;
  }

  public AsyncRulesClient rules() {
    return this.rulesClient.get();
  }

  public AsyncFlowsClient flows() {
    return this.flowsClient.get();
  }

  public AsyncFoldersClient folders() {
    return this.foldersClient.get();
  }
}
