/**
 * This file was auto-generated by Fern from our API Definition.
 */

package resources.values;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import core.ClientOptions;
import core.MediaTypes;
import core.ObjectMappers;
import core.QueryStringMapper;
import core.RequestOptions;
import core.RulebricksApiApiException;
import core.RulebricksApiException;
import errors.BadRequestError;
import errors.ForbiddenError;
import errors.InternalServerError;
import errors.NotFoundError;
import java.io.IOException;
import java.lang.Object;
import java.lang.String;
import java.util.List;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import resources.values.requests.UpdateValuesRequest;
import resources.values.requests.ValuesDeleteRequest;
import resources.values.requests.ValuesListRequest;
import types.DynamicValue;
import types.SuccessMessage;

public class ValuesClient {
  protected final ClientOptions clientOptions;

  public ValuesClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
  }

  /**
   * Retrieve all dynamic values for the authenticated user. Use the 'include' parameter to control whether usage information is returned.
   */
  public List<DynamicValue> list() {
    return list(ValuesListRequest.builder().build());
  }

  /**
   * Retrieve all dynamic values for the authenticated user. Use the 'include' parameter to control whether usage information is returned.
   */
  public List<DynamicValue> list(ValuesListRequest request) {
    return list(request,null);
  }

  /**
   * Retrieve all dynamic values for the authenticated user. Use the 'include' parameter to control whether usage information is returned.
   */
  public List<DynamicValue> list(ValuesListRequest request, RequestOptions requestOptions) {
    HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

      .addPathSegments("values");if (request.getName().isPresent()) {
        QueryStringMapper.addQueryParameter(httpUrl, "name", request.getName().get(), false);
      }
      if (request.getInclude().isPresent()) {
        QueryStringMapper.addQueryParameter(httpUrl, "include", request.getInclude().get(), false);
      }
      Request.Builder _requestBuilder = new Request.Builder()
        .url(httpUrl.build())
        .method("GET", null)
        .headers(Headers.of(clientOptions.headers(requestOptions)))
        .addHeader("Content-Type", "application/json")
        .addHeader("Accept", "application/json");
      Request okhttpRequest = _requestBuilder.build();
      OkHttpClient client = clientOptions.httpClient();
      if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
        client = clientOptions.httpClientWithTimeout(requestOptions);
      }
      try (Response response = client.newCall(okhttpRequest).execute()) {
        ResponseBody responseBody = response.body();
        if (response.isSuccessful()) {
          return ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), new TypeReference<List<DynamicValue>>() {});
        }
        String responseBodyString = responseBody != null ? responseBody.string() : "{}";
        try {
          switch (response.code()) {
            case 404:throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            case 500:throw new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
          }
        }
        catch (JsonProcessingException ignored) {
          // unable to map error response, throwing generic error
        }
        throw new RulebricksApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
      }
      catch (IOException e) {
        throw new RulebricksApiException("Network error executing HTTP request", e);
      }
    }

    /**
     * Update existing dynamic values or add new ones for the authenticated user. Supports both flat and nested object structures. Nested objects are automatically flattened using dot notation and keys are converted to readable format (e.g., 'user_name' becomes 'User Name', nested 'user.contact_info.email' becomes 'User.Contact Info.Email').
     */
    public List<DynamicValue> update(UpdateValuesRequest request) {
      return update(request,null);
    }

    /**
     * Update existing dynamic values or add new ones for the authenticated user. Supports both flat and nested object structures. Nested objects are automatically flattened using dot notation and keys are converted to readable format (e.g., 'user_name' becomes 'User Name', nested 'user.contact_info.email' becomes 'User.Contact Info.Email').
     */
    public List<DynamicValue> update(UpdateValuesRequest request, RequestOptions requestOptions) {
      HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

        .addPathSegments("values")
        .build();
      RequestBody body;
      try {
        body = RequestBody.create(ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
      }
      catch(JsonProcessingException e) {
        throw new RulebricksApiException("Failed to serialize request", e);
      }
      Request okhttpRequest = new Request.Builder()
        .url(httpUrl)
        .method("POST", body)
        .headers(Headers.of(clientOptions.headers(requestOptions)))
        .addHeader("Content-Type", "application/json")
        .addHeader("Accept", "application/json")
        .build();
      OkHttpClient client = clientOptions.httpClient();
      if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
        client = clientOptions.httpClientWithTimeout(requestOptions);
      }
      try (Response response = client.newCall(okhttpRequest).execute()) {
        ResponseBody responseBody = response.body();
        if (response.isSuccessful()) {
          return ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), new TypeReference<List<DynamicValue>>() {});
        }
        String responseBodyString = responseBody != null ? responseBody.string() : "{}";
        try {
          switch (response.code()) {
            case 400:throw new BadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            case 403:throw new ForbiddenError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            case 500:throw new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
          }
        }
        catch (JsonProcessingException ignored) {
          // unable to map error response, throwing generic error
        }
        throw new RulebricksApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
      }
      catch (IOException e) {
        throw new RulebricksApiException("Network error executing HTTP request", e);
      }
    }

    /**
     * Delete a specific dynamic value for the authenticated user by its ID.
     */
    public SuccessMessage delete(ValuesDeleteRequest request) {
      return delete(request,null);
    }

    /**
     * Delete a specific dynamic value for the authenticated user by its ID.
     */
    public SuccessMessage delete(ValuesDeleteRequest request, RequestOptions requestOptions) {
      HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

        .addPathSegments("values");QueryStringMapper.addQueryParameter(httpUrl, "id", request.getId(), false);
        Request.Builder _requestBuilder = new Request.Builder()
          .url(httpUrl.build())
          .method("DELETE", null)
          .headers(Headers.of(clientOptions.headers(requestOptions)))
          .addHeader("Content-Type", "application/json")
          .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
          client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
          ResponseBody responseBody = response.body();
          if (response.isSuccessful()) {
            return ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), SuccessMessage.class);
          }
          String responseBodyString = responseBody != null ? responseBody.string() : "{}";
          try {
            switch (response.code()) {
              case 400:throw new BadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
              case 404:throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
              case 500:throw new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
          }
          catch (JsonProcessingException ignored) {
            // unable to map error response, throwing generic error
          }
          throw new RulebricksApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
          throw new RulebricksApiException("Network error executing HTTP request", e);
        }
      }
    }
