/*
 * Decompiled with CFR 0.152.
 */
package core;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.Nullable;

public class InputStreamRequestBody
extends RequestBody {
    private final InputStream inputStream;
    private final MediaType contentType;

    public InputStreamRequestBody(@Nullable MediaType contentType, InputStream inputStream) {
        this.contentType = contentType;
        this.inputStream = Objects.requireNonNull(inputStream, "inputStream == null");
    }

    @Nullable
    public MediaType contentType() {
        return this.contentType;
    }

    public long contentLength() throws IOException {
        return this.inputStream.available() == 0 ? -1L : (long)this.inputStream.available();
    }

    public void writeTo(BufferedSink sink) throws IOException {
        Source source = null;
        try {
            source = Okio.source((InputStream)this.inputStream);
            sink.writeAll(source);
        }
        finally {
            Util.closeQuietly((Closeable)((Closeable)Objects.requireNonNull(source)));
        }
    }
}

