/*
 * Decompiled with CFR 0.152.
 */
package types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DecisionLogResponse {
    private final Optional<List<Map<String, Object>>> data;
    private final Optional<String> cursor;
    private final Map<String, Object> additionalProperties;

    private DecisionLogResponse(Optional<List<Map<String, Object>>> data, Optional<String> cursor, Map<String, Object> additionalProperties) {
        this.data = data;
        this.cursor = cursor;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="data")
    public Optional<List<Map<String, Object>>> getData() {
        return this.data;
    }

    @JsonProperty(value="cursor")
    public Optional<String> getCursor() {
        return this.cursor;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DecisionLogResponse && this.equalTo((DecisionLogResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DecisionLogResponse other) {
        return this.data.equals(other.data) && this.cursor.equals(other.cursor);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.cursor);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Map<String, Object>>> data = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(DecisionLogResponse other) {
            this.data(other.getData());
            this.cursor(other.getCursor());
            return this;
        }

        @JsonSetter(value="data", nulls=Nulls.SKIP)
        public Builder data(Optional<List<Map<String, Object>>> data) {
            this.data = data;
            return this;
        }

        public Builder data(List<Map<String, Object>> data) {
            this.data = Optional.ofNullable(data);
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        public DecisionLogResponse build() {
            return new DecisionLogResponse(this.data, this.cursor, this.additionalProperties);
        }
    }
}

