/*
 * Decompiled with CFR 0.152.
 */
package types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import types.TestTestState;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Test {
    private final String id;
    private final String name;
    private final Map<String, Object> request;
    private final Map<String, Object> response;
    private final boolean critical;
    private final boolean error;
    private final boolean success;
    private final Optional<TestTestState> testState;
    private final Optional<OffsetDateTime> lastExecuted;
    private final Map<String, Object> additionalProperties;

    private Test(String id, String name, Map<String, Object> request, Map<String, Object> response, boolean critical, boolean error, boolean success, Optional<TestTestState> testState, Optional<OffsetDateTime> lastExecuted, Map<String, Object> additionalProperties) {
        this.id = id;
        this.name = name;
        this.request = request;
        this.response = response;
        this.critical = critical;
        this.error = error;
        this.success = success;
        this.testState = testState;
        this.lastExecuted = lastExecuted;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="request")
    public Map<String, Object> getRequest() {
        return this.request;
    }

    @JsonProperty(value="response")
    public Map<String, Object> getResponse() {
        return this.response;
    }

    @JsonProperty(value="critical")
    public boolean getCritical() {
        return this.critical;
    }

    @JsonProperty(value="error")
    public boolean getError() {
        return this.error;
    }

    @JsonProperty(value="success")
    public boolean getSuccess() {
        return this.success;
    }

    @JsonProperty(value="testState")
    public Optional<TestTestState> getTestState() {
        return this.testState;
    }

    @JsonProperty(value="lastExecuted")
    public Optional<OffsetDateTime> getLastExecuted() {
        return this.lastExecuted;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Test && this.equalTo((Test)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Test other) {
        return this.id.equals(other.id) && this.name.equals(other.name) && this.request.equals(other.request) && this.response.equals(other.response) && this.critical == other.critical && this.error == other.error && this.success == other.success && this.testState.equals(other.testState) && this.lastExecuted.equals(other.lastExecuted);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.request, this.response, this.critical, this.error, this.success, this.testState, this.lastExecuted);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    NameStage,
    CriticalStage,
    ErrorStage,
    SuccessStage,
    _FinalStage {
        private String id;
        private String name;
        private boolean critical;
        private boolean error;
        private boolean success;
        private Optional<OffsetDateTime> lastExecuted = Optional.empty();
        private Optional<TestTestState> testState = Optional.empty();
        private Map<String, Object> response = new LinkedHashMap<String, Object>();
        private Map<String, Object> request = new LinkedHashMap<String, Object>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Test other) {
            this.id(other.getId());
            this.name(other.getName());
            this.request(other.getRequest());
            this.response(other.getResponse());
            this.critical(other.getCritical());
            this.error(other.getError());
            this.success(other.getSuccess());
            this.testState(other.getTestState());
            this.lastExecuted(other.getLastExecuted());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public CriticalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="critical")
        public ErrorStage critical(boolean critical) {
            this.critical = critical;
            return this;
        }

        @Override
        @JsonSetter(value="error")
        public SuccessStage error(boolean error) {
            this.error = error;
            return this;
        }

        @Override
        @JsonSetter(value="success")
        public _FinalStage success(boolean success) {
            this.success = success;
            return this;
        }

        @Override
        public _FinalStage lastExecuted(OffsetDateTime lastExecuted) {
            this.lastExecuted = Optional.ofNullable(lastExecuted);
            return this;
        }

        @Override
        @JsonSetter(value="lastExecuted", nulls=Nulls.SKIP)
        public _FinalStage lastExecuted(Optional<OffsetDateTime> lastExecuted) {
            this.lastExecuted = lastExecuted;
            return this;
        }

        @Override
        public _FinalStage testState(TestTestState testState) {
            this.testState = Optional.ofNullable(testState);
            return this;
        }

        @Override
        @JsonSetter(value="testState", nulls=Nulls.SKIP)
        public _FinalStage testState(Optional<TestTestState> testState) {
            this.testState = testState;
            return this;
        }

        @Override
        public _FinalStage response(String key, Object value) {
            this.response.put(key, value);
            return this;
        }

        @Override
        public _FinalStage putAllResponse(Map<String, Object> response) {
            this.response.putAll(response);
            return this;
        }

        @Override
        @JsonSetter(value="response", nulls=Nulls.SKIP)
        public _FinalStage response(Map<String, Object> response) {
            this.response.clear();
            this.response.putAll(response);
            return this;
        }

        @Override
        public _FinalStage request(String key, Object value) {
            this.request.put(key, value);
            return this;
        }

        @Override
        public _FinalStage putAllRequest(Map<String, Object> request) {
            this.request.putAll(request);
            return this;
        }

        @Override
        @JsonSetter(value="request", nulls=Nulls.SKIP)
        public _FinalStage request(Map<String, Object> request) {
            this.request.clear();
            this.request.putAll(request);
            return this;
        }

        @Override
        public Test build() {
            return new Test(this.id, this.name, this.request, this.response, this.critical, this.error, this.success, this.testState, this.lastExecuted, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Test build();

        public _FinalStage request(Map<String, Object> var1);

        public _FinalStage putAllRequest(Map<String, Object> var1);

        public _FinalStage request(String var1, Object var2);

        public _FinalStage response(Map<String, Object> var1);

        public _FinalStage putAllResponse(Map<String, Object> var1);

        public _FinalStage response(String var1, Object var2);

        public _FinalStage testState(Optional<TestTestState> var1);

        public _FinalStage testState(TestTestState var1);

        public _FinalStage lastExecuted(Optional<OffsetDateTime> var1);

        public _FinalStage lastExecuted(OffsetDateTime var1);
    }

    public static interface SuccessStage {
        public _FinalStage success(boolean var1);
    }

    public static interface ErrorStage {
        public SuccessStage error(boolean var1);
    }

    public static interface CriticalStage {
        public ErrorStage critical(boolean var1);
    }

    public static interface NameStage {
        public CriticalStage name(@NotNull String var1);
    }

    public static interface IdStage {
        public NameStage id(@NotNull String var1);

        public Builder from(Test var1);
    }
}

