/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.assets;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.core.RulebricksApiApiException;
import com.rulebricks.core.RulebricksApiException;
import com.rulebricks.core.Suppliers;
import com.rulebricks.resources.assets.flows.FlowsClient;
import com.rulebricks.resources.assets.folders.FoldersClient;
import com.rulebricks.resources.assets.rules.RulesClient;
import com.rulebricks.types.UsageStatistics;
import java.io.IOException;
import java.lang.Object;
import java.lang.String;
import java.util.function.Supplier;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class AssetsClient {
  protected final ClientOptions clientOptions;

  protected final Supplier<RulesClient> rulesClient;

  protected final Supplier<FlowsClient> flowsClient;

  protected final Supplier<FoldersClient> foldersClient;

  public AssetsClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
    this.rulesClient = Suppliers.memoize(() -> new RulesClient(clientOptions));
    this.flowsClient = Suppliers.memoize(() -> new FlowsClient(clientOptions));
    this.foldersClient = Suppliers.memoize(() -> new FoldersClient(clientOptions));
  }

  /**
   * Get the rule execution usage of your organization.
   */
  public UsageStatistics getUsage() {
    return getUsage(null);
  }

  /**
   * Get the rule execution usage of your organization.
   */
  public UsageStatistics getUsage(RequestOptions requestOptions) {
    HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

      .addPathSegments("admin/usage")
      .build();
    Request okhttpRequest = new Request.Builder()
      .url(httpUrl)
      .method("GET", null)
      .headers(Headers.of(clientOptions.headers(requestOptions)))
      .addHeader("Content-Type", "application/json")
      .addHeader("Accept", "application/json")
      .build();
    OkHttpClient client = clientOptions.httpClient();
    if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
      client = clientOptions.httpClientWithTimeout(requestOptions);
    }
    try (Response response = client.newCall(okhttpRequest).execute()) {
      ResponseBody responseBody = response.body();
      if (response.isSuccessful()) {
        return ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UsageStatistics.class);
      }
      String responseBodyString = responseBody != null ? responseBody.string() : "{}";
      throw new RulebricksApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
    }
    catch (IOException e) {
      throw new RulebricksApiException("Network error executing HTTP request", e);
    }
  }

  public RulesClient rules() {
    return this.rulesClient.get();
  }

  public FlowsClient flows() {
    return this.flowsClient.get();
  }

  public FoldersClient folders() {
    return this.foldersClient.get();
  }
}
