/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.assets.folders;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.MediaTypes;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.core.RulebricksApiApiException;
import com.rulebricks.core.RulebricksApiException;
import com.rulebricks.errors.BadRequestError;
import com.rulebricks.errors.InternalServerError;
import com.rulebricks.errors.NotFoundError;
import com.rulebricks.resources.assets.folders.requests.DeleteFolderRequest;
import com.rulebricks.resources.assets.folders.requests.UpsertFolderRequest;
import com.rulebricks.types.Folder;
import java.io.IOException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class AsyncFoldersClient {
  protected final ClientOptions clientOptions;

  public AsyncFoldersClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
  }

  /**
   * Retrieve all rule folders for the authenticated user.
   */
  public CompletableFuture<List<Folder>> list() {
    return list(null);
  }

  /**
   * Retrieve all rule folders for the authenticated user.
   */
  public CompletableFuture<List<Folder>> list(RequestOptions requestOptions) {
    HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

      .addPathSegments("admin/folders")
      .build();
    Request okhttpRequest = new Request.Builder()
      .url(httpUrl)
      .method("GET", null)
      .headers(Headers.of(clientOptions.headers(requestOptions)))
      .addHeader("Content-Type", "application/json")
      .addHeader("Accept", "application/json")
      .build();
    OkHttpClient client = clientOptions.httpClient();
    if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
      client = clientOptions.httpClientWithTimeout(requestOptions);
    }
    CompletableFuture<List<Folder>> future = new CompletableFuture<>();
    client.newCall(okhttpRequest).enqueue(new Callback() {
      @Override
      public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
        try (ResponseBody responseBody = response.body()) {
          if (response.isSuccessful()) {
            future.complete(ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), new TypeReference<List<Folder>>() {}));
            return;
          }
          String responseBodyString = responseBody != null ? responseBody.string() : "{}";
          try {
            if (response.code() == 500) {
              future.completeExceptionally(new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class)));
              return;
            }
          }
          catch (JsonProcessingException ignored) {
            // unable to map error response, throwing generic error
          }
          future.completeExceptionally(new RulebricksApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class)));
          return;
        }
        catch (IOException e) {
          future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
        }
      }

      @Override
      public void onFailure(@NotNull Call call, @NotNull IOException e) {
        future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
      }
    });
    return future;
  }

  /**
   * Create a new rule folder or update an existing one for the authenticated user.
   */
  public CompletableFuture<Folder> upsert(UpsertFolderRequest request) {
    return upsert(request,null);
  }

  /**
   * Create a new rule folder or update an existing one for the authenticated user.
   */
  public CompletableFuture<Folder> upsert(UpsertFolderRequest request,
      RequestOptions requestOptions) {
    HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

      .addPathSegments("admin/folders")
      .build();
    RequestBody body;
    try {
      body = RequestBody.create(ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
    }
    catch(JsonProcessingException e) {
      throw new RulebricksApiException("Failed to serialize request", e);
    }
    Request okhttpRequest = new Request.Builder()
      .url(httpUrl)
      .method("POST", body)
      .headers(Headers.of(clientOptions.headers(requestOptions)))
      .addHeader("Content-Type", "application/json")
      .addHeader("Accept", "application/json")
      .build();
    OkHttpClient client = clientOptions.httpClient();
    if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
      client = clientOptions.httpClientWithTimeout(requestOptions);
    }
    CompletableFuture<Folder> future = new CompletableFuture<>();
    client.newCall(okhttpRequest).enqueue(new Callback() {
      @Override
      public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
        try (ResponseBody responseBody = response.body()) {
          if (response.isSuccessful()) {
            future.complete(ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), Folder.class));
            return;
          }
          String responseBodyString = responseBody != null ? responseBody.string() : "{}";
          try {
            switch (response.code()) {
              case 400:future.completeExceptionally(new BadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class)));
              return;
              case 500:future.completeExceptionally(new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class)));
              return;
            }
          }
          catch (JsonProcessingException ignored) {
            // unable to map error response, throwing generic error
          }
          future.completeExceptionally(new RulebricksApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class)));
          return;
        }
        catch (IOException e) {
          future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
        }
      }

      @Override
      public void onFailure(@NotNull Call call, @NotNull IOException e) {
        future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
      }
    });
    return future;
  }

  /**
   * Delete a specific rule folder for the authenticated user. This does not delete the rules within the folder.
   */
  public CompletableFuture<Folder> delete(DeleteFolderRequest request) {
    return delete(request,null);
  }

  /**
   * Delete a specific rule folder for the authenticated user. This does not delete the rules within the folder.
   */
  public CompletableFuture<Folder> delete(DeleteFolderRequest request,
      RequestOptions requestOptions) {
    HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

      .addPathSegments("admin/folders")
      .build();
    RequestBody body;
    try {
      body = RequestBody.create(ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
    }
    catch(JsonProcessingException e) {
      throw new RulebricksApiException("Failed to serialize request", e);
    }
    Request okhttpRequest = new Request.Builder()
      .url(httpUrl)
      .method("DELETE", body)
      .headers(Headers.of(clientOptions.headers(requestOptions)))
      .addHeader("Content-Type", "application/json")
      .addHeader("Accept", "application/json")
      .build();
    OkHttpClient client = clientOptions.httpClient();
    if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
      client = clientOptions.httpClientWithTimeout(requestOptions);
    }
    CompletableFuture<Folder> future = new CompletableFuture<>();
    client.newCall(okhttpRequest).enqueue(new Callback() {
      @Override
      public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
        try (ResponseBody responseBody = response.body()) {
          if (response.isSuccessful()) {
            future.complete(ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), Folder.class));
            return;
          }
          String responseBodyString = responseBody != null ? responseBody.string() : "{}";
          try {
            switch (response.code()) {
              case 400:future.completeExceptionally(new BadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class)));
              return;
              case 404:future.completeExceptionally(new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class)));
              return;
              case 500:future.completeExceptionally(new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class)));
              return;
            }
          }
          catch (JsonProcessingException ignored) {
            // unable to map error response, throwing generic error
          }
          future.completeExceptionally(new RulebricksApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class)));
          return;
        }
        catch (IOException e) {
          future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
        }
      }

      @Override
      public void onFailure(@NotNull Call call, @NotNull IOException e) {
        future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
      }
    });
    return future;
  }
}
