/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.assets.rules.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = RulesListRequest.Builder.class
)
public final class RulesListRequest {
  private final Optional<String> folder;

  private final Map<String, Object> additionalProperties;

  private RulesListRequest(Optional<String> folder, Map<String, Object> additionalProperties) {
    this.folder = folder;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Filter rules by folder name or folder ID
   */
  @JsonProperty("folder")
  public Optional<String> getFolder() {
    return folder;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof RulesListRequest && equalTo((RulesListRequest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(RulesListRequest other) {
    return folder.equals(other.folder);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.folder);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> folder = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(RulesListRequest other) {
      folder(other.getFolder());
      return this;
    }

    @JsonSetter(
        value = "folder",
        nulls = Nulls.SKIP
    )
    public Builder folder(Optional<String> folder) {
      this.folder = folder;
      return this;
    }

    public Builder folder(String folder) {
      this.folder = Optional.ofNullable(folder);
      return this;
    }

    public RulesListRequest build() {
      return new RulesListRequest(folder, additionalProperties);
    }
  }
}
