/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.values.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = UpdateValuesRequest.Builder.class
)
public final class UpdateValuesRequest {
  private final Map<String, Object> values;

  private final Optional<List<String>> accessGroups;

  private final Map<String, Object> additionalProperties;

  private UpdateValuesRequest(Map<String, Object> values, Optional<List<String>> accessGroups,
      Map<String, Object> additionalProperties) {
    this.values = values;
    this.accessGroups = accessGroups;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return A dictionary of keys and values to update or add. Supports both flat key-value pairs and nested objects. Nested objects will be automatically flattened using dot notation with readable key names (e.g., 'user.contact_info.email' becomes 'User.Contact Info.Email').
   */
  @JsonProperty("values")
  public Map<String, Object> getValues() {
    return values;
  }

  /**
   * @return Optional array of access group names or IDs. If omitted and user belongs to access groups, values will be assigned to all user's access groups. Required if values should be restricted to specific access groups.
   */
  @JsonProperty("accessGroups")
  public Optional<List<String>> getAccessGroups() {
    return accessGroups;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof UpdateValuesRequest && equalTo((UpdateValuesRequest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(UpdateValuesRequest other) {
    return values.equals(other.values) && accessGroups.equals(other.accessGroups);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.values, this.accessGroups);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Map<String, Object> values = new LinkedHashMap<>();

    private Optional<List<String>> accessGroups = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(UpdateValuesRequest other) {
      values(other.getValues());
      accessGroups(other.getAccessGroups());
      return this;
    }

    @JsonSetter(
        value = "values",
        nulls = Nulls.SKIP
    )
    public Builder values(Map<String, Object> values) {
      this.values.clear();
      this.values.putAll(values);
      return this;
    }

    public Builder putAllValues(Map<String, Object> values) {
      this.values.putAll(values);
      return this;
    }

    public Builder values(String key, Object value) {
      this.values.put(key, value);
      return this;
    }

    @JsonSetter(
        value = "accessGroups",
        nulls = Nulls.SKIP
    )
    public Builder accessGroups(Optional<List<String>> accessGroups) {
      this.accessGroups = accessGroups;
      return this;
    }

    public Builder accessGroups(List<String> accessGroups) {
      this.accessGroups = Optional.ofNullable(accessGroups);
      return this;
    }

    public UpdateValuesRequest build() {
      return new UpdateValuesRequest(values, accessGroups, additionalProperties);
    }
  }
}
