/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.values.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = ValuesListRequest.Builder.class
)
public final class ValuesListRequest {
  private final Optional<String> name;

  private final Optional<String> include;

  private final Map<String, Object> additionalProperties;

  private ValuesListRequest(Optional<String> name, Optional<String> include,
      Map<String, Object> additionalProperties) {
    this.name = name;
    this.include = include;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Query all dynamic values containing a specific name
   */
  @JsonProperty("name")
  public Optional<String> getName() {
    return name;
  }

  /**
   * @return Comma-separated list of additional data to include. Use 'usage' to include which rules reference each value.
   */
  @JsonProperty("include")
  public Optional<String> getInclude() {
    return include;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ValuesListRequest && equalTo((ValuesListRequest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ValuesListRequest other) {
    return name.equals(other.name) && include.equals(other.include);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.name, this.include);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> name = Optional.empty();

    private Optional<String> include = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(ValuesListRequest other) {
      name(other.getName());
      include(other.getInclude());
      return this;
    }

    @JsonSetter(
        value = "name",
        nulls = Nulls.SKIP
    )
    public Builder name(Optional<String> name) {
      this.name = name;
      return this;
    }

    public Builder name(String name) {
      this.name = Optional.ofNullable(name);
      return this;
    }

    @JsonSetter(
        value = "include",
        nulls = Nulls.SKIP
    )
    public Builder include(Optional<String> include) {
      this.include = include;
      return this;
    }

    public Builder include(String include) {
      this.include = Optional.ofNullable(include);
      return this;
    }

    public ValuesListRequest build() {
      return new ValuesListRequest(name, include, additionalProperties);
    }
  }
}
