/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = ParallelSolveRequestValue.Builder.class
)
public final class ParallelSolveRequestValue {
  private final Optional<String> rule;

  private final Optional<String> flow;

  private final Map<String, Object> additionalProperties;

  private ParallelSolveRequestValue(Optional<String> rule, Optional<String> flow,
      Map<String, Object> additionalProperties) {
    this.rule = rule;
    this.flow = flow;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Slug of the rule to execute
   */
  @JsonProperty("$rule")
  public Optional<String> getRule() {
    return rule;
  }

  /**
   * @return Slug of the flow to execute
   */
  @JsonProperty("$flow")
  public Optional<String> getFlow() {
    return flow;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ParallelSolveRequestValue && equalTo((ParallelSolveRequestValue) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ParallelSolveRequestValue other) {
    return rule.equals(other.rule) && flow.equals(other.flow);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.rule, this.flow);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> rule = Optional.empty();

    private Optional<String> flow = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(ParallelSolveRequestValue other) {
      rule(other.getRule());
      flow(other.getFlow());
      return this;
    }

    @JsonSetter(
        value = "$rule",
        nulls = Nulls.SKIP
    )
    public Builder rule(Optional<String> rule) {
      this.rule = rule;
      return this;
    }

    public Builder rule(String rule) {
      this.rule = Optional.ofNullable(rule);
      return this;
    }

    @JsonSetter(
        value = "$flow",
        nulls = Nulls.SKIP
    )
    public Builder flow(Optional<String> flow) {
      this.flow = flow;
      return this;
    }

    public Builder flow(String flow) {
      this.flow = Optional.ofNullable(flow);
      return this;
    }

    public ParallelSolveRequestValue build() {
      return new ParallelSolveRequestValue(rule, flow, additionalProperties);
    }
  }
}
