/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = UserInviteResponse.Builder.class
)
public final class UserInviteResponse {
  private final Optional<String> message;

  private final Optional<UserInviteResponseUser> user;

  private final Map<String, Object> additionalProperties;

  private UserInviteResponse(Optional<String> message, Optional<UserInviteResponseUser> user,
      Map<String, Object> additionalProperties) {
    this.message = message;
    this.user = user;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Success message indicating whether a new user was invited or an existing user's permissions were updated.
   */
  @JsonProperty("message")
  public Optional<String> getMessage() {
    return message;
  }

  @JsonProperty("user")
  public Optional<UserInviteResponseUser> getUser() {
    return user;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof UserInviteResponse && equalTo((UserInviteResponse) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(UserInviteResponse other) {
    return message.equals(other.message) && user.equals(other.user);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.message, this.user);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> message = Optional.empty();

    private Optional<UserInviteResponseUser> user = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(UserInviteResponse other) {
      message(other.getMessage());
      user(other.getUser());
      return this;
    }

    @JsonSetter(
        value = "message",
        nulls = Nulls.SKIP
    )
    public Builder message(Optional<String> message) {
      this.message = message;
      return this;
    }

    public Builder message(String message) {
      this.message = Optional.ofNullable(message);
      return this;
    }

    @JsonSetter(
        value = "user",
        nulls = Nulls.SKIP
    )
    public Builder user(Optional<UserInviteResponseUser> user) {
      this.user = user;
      return this;
    }

    public Builder user(UserInviteResponseUser user) {
      this.user = Optional.ofNullable(user);
      return this;
    }

    public UserInviteResponse build() {
      return new UserInviteResponse(message, user, additionalProperties);
    }
  }
}
