/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks;

import com.rulebricks.AsyncRulebricksApiClient;
import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.Environment;
import okhttp3.OkHttpClient;

public final class AsyncRulebricksApiClientBuilder {
    private ClientOptions.Builder clientOptionsBuilder = ClientOptions.builder();
    private String apiKey = null;
    private Environment environment = Environment.DEFAULT;

    public AsyncRulebricksApiClientBuilder apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public AsyncRulebricksApiClientBuilder environment(Environment environment) {
        this.environment = environment;
        return this;
    }

    public AsyncRulebricksApiClientBuilder url(String url) {
        this.environment = Environment.custom(url);
        return this;
    }

    public AsyncRulebricksApiClientBuilder timeout(int timeout) {
        this.clientOptionsBuilder.timeout(timeout);
        return this;
    }

    public AsyncRulebricksApiClientBuilder maxRetries(int maxRetries) {
        this.clientOptionsBuilder.maxRetries(maxRetries);
        return this;
    }

    public AsyncRulebricksApiClientBuilder httpClient(OkHttpClient httpClient) {
        this.clientOptionsBuilder.httpClient(httpClient);
        return this;
    }

    public AsyncRulebricksApiClient build() {
        if (this.apiKey == null) {
            throw new RuntimeException("Please provide apiKey");
        }
        this.clientOptionsBuilder.addHeader("x-api-key", this.apiKey);
        this.clientOptionsBuilder.environment(this.environment);
        return new AsyncRulebricksApiClient(this.clientOptionsBuilder.build());
    }
}

