/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks;

import com.rulebricks.RulebricksApiClient;
import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.Environment;
import okhttp3.OkHttpClient;

public final class RulebricksApiClientBuilder {
    private ClientOptions.Builder clientOptionsBuilder = ClientOptions.builder();
    private String apiKey = null;
    private Environment environment = Environment.DEFAULT;

    public RulebricksApiClientBuilder apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public RulebricksApiClientBuilder environment(Environment environment) {
        this.environment = environment;
        return this;
    }

    public RulebricksApiClientBuilder url(String url) {
        this.environment = Environment.custom(url);
        return this;
    }

    public RulebricksApiClientBuilder timeout(int timeout) {
        this.clientOptionsBuilder.timeout(timeout);
        return this;
    }

    public RulebricksApiClientBuilder maxRetries(int maxRetries) {
        this.clientOptionsBuilder.maxRetries(maxRetries);
        return this;
    }

    public RulebricksApiClientBuilder httpClient(OkHttpClient httpClient) {
        this.clientOptionsBuilder.httpClient(httpClient);
        return this;
    }

    public RulebricksApiClient build() {
        if (this.apiKey == null) {
            throw new RuntimeException("Please provide apiKey");
        }
        this.clientOptionsBuilder.addHeader("x-api-key", this.apiKey);
        this.clientOptionsBuilder.environment(this.environment);
        return new RulebricksApiClient(this.clientOptionsBuilder.build());
    }
}

