/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public final class RequestOptions {
    private final String apiKey;
    private final Optional<Integer> timeout;
    private final TimeUnit timeoutTimeUnit;
    private final Map<String, String> headers;
    private final Map<String, Supplier<String>> headerSuppliers;

    private RequestOptions(String apiKey, Optional<Integer> timeout, TimeUnit timeoutTimeUnit, Map<String, String> headers, Map<String, Supplier<String>> headerSuppliers) {
        this.apiKey = apiKey;
        this.timeout = timeout;
        this.timeoutTimeUnit = timeoutTimeUnit;
        this.headers = headers;
        this.headerSuppliers = headerSuppliers;
    }

    public Optional<Integer> getTimeout() {
        return this.timeout;
    }

    public TimeUnit getTimeoutTimeUnit() {
        return this.timeoutTimeUnit;
    }

    public Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (this.apiKey != null) {
            headers.put("x-api-key", this.apiKey);
        }
        headers.putAll(this.headers);
        this.headerSuppliers.forEach((key, supplier) -> headers.put((String)key, (String)supplier.get()));
        return headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String apiKey = null;
        private Optional<Integer> timeout = Optional.empty();
        private TimeUnit timeoutTimeUnit = TimeUnit.SECONDS;
        private final Map<String, String> headers = new HashMap<String, String>();
        private final Map<String, Supplier<String>> headerSuppliers = new HashMap<String, Supplier<String>>();

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder timeout(Integer timeout) {
            this.timeout = Optional.of(timeout);
            return this;
        }

        public Builder timeout(Integer timeout, TimeUnit timeoutTimeUnit) {
            this.timeout = Optional.of(timeout);
            this.timeoutTimeUnit = timeoutTimeUnit;
            return this;
        }

        public Builder addHeader(String key, String value) {
            this.headers.put(key, value);
            return this;
        }

        public Builder addHeader(String key, Supplier<String> value) {
            this.headerSuppliers.put(key, value);
            return this;
        }

        public RequestOptions build() {
            return new RequestOptions(this.apiKey, this.timeout, this.timeoutTimeUnit, this.headers, this.headerSuppliers);
        }
    }
}

