/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.resources.assets.flows;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.core.RulebricksApiApiException;
import com.rulebricks.core.RulebricksApiException;
import com.rulebricks.errors.InternalServerError;
import com.rulebricks.types.FlowDetail;
import java.io.IOException;
import java.util.List;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class FlowsClient {
    protected final ClientOptions clientOptions;

    public FlowsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public List<FlowDetail> list() {
        return this.list(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<FlowDetail> list(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("admin/flows/list").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                List list = (List)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), (TypeReference)new TypeReference<List<FlowDetail>>(){});
                return list;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                if (response.code() != 500) throw new RulebricksApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                throw new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new RulebricksApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new RulebricksApiException("Network error executing HTTP request", e);
        }
    }
}

