/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.assets;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.core.RulebricksApiApiException;
import com.rulebricks.core.RulebricksApiException;
import com.rulebricks.core.RulebricksApiHttpResponse;
import com.rulebricks.types.UsageStatistics;
import java.io.IOException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class AsyncRawAssetsClient {
  protected final ClientOptions clientOptions;

  public AsyncRawAssetsClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
  }

  /**
   * Get the rule execution usage of your organization.
   */
  public CompletableFuture<RulebricksApiHttpResponse<UsageStatistics>> getUsage() {
    return getUsage(null);
  }

  /**
   * Get the rule execution usage of your organization.
   */
  public CompletableFuture<RulebricksApiHttpResponse<UsageStatistics>> getUsage(
      RequestOptions requestOptions) {
    HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

      .addPathSegments("admin/usage")
      .build();
    Request okhttpRequest = new Request.Builder()
      .url(httpUrl)
      .method("GET", null)
      .headers(Headers.of(clientOptions.headers(requestOptions)))
      .addHeader("Accept", "application/json")
      .build();
    OkHttpClient client = clientOptions.httpClient();
    if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
      client = clientOptions.httpClientWithTimeout(requestOptions);
    }
    CompletableFuture<RulebricksApiHttpResponse<UsageStatistics>> future = new CompletableFuture<>();
    client.newCall(okhttpRequest).enqueue(new Callback() {
      @Override
      public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
        try (ResponseBody responseBody = response.body()) {
          String responseBodyString = responseBody != null ? responseBody.string() : "{}";
          if (response.isSuccessful()) {
            future.complete(new RulebricksApiHttpResponse<>(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, UsageStatistics.class), response));
            return;
          }
          Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
          future.completeExceptionally(new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response));
          return;
        }
        catch (IOException e) {
          future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
        }
      }

      @Override
      public void onFailure(@NotNull Call call, @NotNull IOException e) {
        future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
      }
    });
    return future;
  }
}
