/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.flows;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.resources.flows.requests.ExecuteFlowsRequest;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class AsyncFlowsClient {
  protected final ClientOptions clientOptions;

  private final AsyncRawFlowsClient rawClient;

  public AsyncFlowsClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
    this.rawClient = new AsyncRawFlowsClient(clientOptions);
  }

  /**
   * Get responses with HTTP metadata like headers
   */
  public AsyncRawFlowsClient withRawResponse() {
    return this.rawClient;
  }

  /**
   * Execute a flow by its slug.
   */
  public CompletableFuture<Map<String, Object>> execute(String slug, ExecuteFlowsRequest request) {
    return this.rawClient.execute(slug, request).thenApply(response -> response.body());
  }

  /**
   * Execute a flow by its slug.
   */
  public CompletableFuture<Map<String, Object>> execute(String slug, ExecuteFlowsRequest request,
      RequestOptions requestOptions) {
    return this.rawClient.execute(slug, request, requestOptions).thenApply(response -> response.body());
  }
}
