/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.tests.flows;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.resources.tests.flows.requests.CreateFlowsRequest;
import com.rulebricks.resources.tests.flows.requests.DeleteFlowsRequest;
import com.rulebricks.resources.tests.flows.requests.ListFlowsRequest;
import com.rulebricks.types.Test;
import java.lang.String;
import java.util.List;

public class FlowsClient {
  protected final ClientOptions clientOptions;

  private final RawFlowsClient rawClient;

  public FlowsClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
    this.rawClient = new RawFlowsClient(clientOptions);
  }

  /**
   * Get responses with HTTP metadata like headers
   */
  public RawFlowsClient withRawResponse() {
    return this.rawClient;
  }

  /**
   * Retrieves a list of tests associated with the flow identified by the slug.
   */
  public List<Test> list(String slug) {
    return this.rawClient.list(slug).body();
  }

  /**
   * Retrieves a list of tests associated with the flow identified by the slug.
   */
  public List<Test> list(String slug, ListFlowsRequest request) {
    return this.rawClient.list(slug, request).body();
  }

  /**
   * Retrieves a list of tests associated with the flow identified by the slug.
   */
  public List<Test> list(String slug, ListFlowsRequest request, RequestOptions requestOptions) {
    return this.rawClient.list(slug, request, requestOptions).body();
  }

  /**
   * Adds a new test to the test suite of a flow identified by the slug.
   */
  public Test create(String slug, CreateFlowsRequest request) {
    return this.rawClient.create(slug, request).body();
  }

  /**
   * Adds a new test to the test suite of a flow identified by the slug.
   */
  public Test create(String slug, CreateFlowsRequest request, RequestOptions requestOptions) {
    return this.rawClient.create(slug, request, requestOptions).body();
  }

  /**
   * Deletes a test from the test suite of a flow identified by the slug.
   */
  public Test delete(String slug, String testId) {
    return this.rawClient.delete(slug, testId).body();
  }

  /**
   * Deletes a test from the test suite of a flow identified by the slug.
   */
  public Test delete(String slug, String testId, DeleteFlowsRequest request) {
    return this.rawClient.delete(slug, testId, request).body();
  }

  /**
   * Deletes a test from the test suite of a flow identified by the slug.
   */
  public Test delete(String slug, String testId, DeleteFlowsRequest request,
      RequestOptions requestOptions) {
    return this.rawClient.delete(slug, testId, request, requestOptions).body();
  }
}
