/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.Nullable;
import com.rulebricks.core.NullableNonemptyFilter;
import com.rulebricks.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = CreateUserResponseUser.Builder.class
)
public final class CreateUserResponseUser {
  private final Optional<String> id;

  private final Optional<String> email;

  private final Optional<String> name;

  private final Optional<String> role;

  private final Optional<List<String>> accessGroups;

  private final Optional<String> apiKey;

  private final Map<String, Object> additionalProperties;

  private CreateUserResponseUser(Optional<String> id, Optional<String> email, Optional<String> name,
      Optional<String> role, Optional<List<String>> accessGroups, Optional<String> apiKey,
      Map<String, Object> additionalProperties) {
    this.id = id;
    this.email = email;
    this.name = name;
    this.role = role;
    this.accessGroups = accessGroups;
    this.apiKey = apiKey;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Unique identifier for the created user.
   */
  @JsonProperty("id")
  public Optional<String> getId() {
    return id;
  }

  /**
   * @return Email address of the created user.
   */
  @JsonProperty("email")
  public Optional<String> getEmail() {
    return email;
  }

  /**
   * @return Display name of the user.
   */
  @JsonIgnore
  public Optional<String> getName() {
    if (name == null) {
      return Optional.empty();
    }
    return name;
  }

  /**
   * @return Role assigned to the user.
   */
  @JsonProperty("role")
  public Optional<String> getRole() {
    return role;
  }

  /**
   * @return Access groups assigned to the user.
   */
  @JsonProperty("accessGroups")
  public Optional<List<String>> getAccessGroups() {
    return accessGroups;
  }

  /**
   * @return API key generated for the user.
   */
  @JsonIgnore
  public Optional<String> getApiKey() {
    if (apiKey == null) {
      return Optional.empty();
    }
    return apiKey;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("name")
  private Optional<String> _getName() {
    return name;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("apiKey")
  private Optional<String> _getApiKey() {
    return apiKey;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof CreateUserResponseUser && equalTo((CreateUserResponseUser) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(CreateUserResponseUser other) {
    return id.equals(other.id) && email.equals(other.email) && name.equals(other.name) && role.equals(other.role) && accessGroups.equals(other.accessGroups) && apiKey.equals(other.apiKey);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.id, this.email, this.name, this.role, this.accessGroups, this.apiKey);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> id = Optional.empty();

    private Optional<String> email = Optional.empty();

    private Optional<String> name = Optional.empty();

    private Optional<String> role = Optional.empty();

    private Optional<List<String>> accessGroups = Optional.empty();

    private Optional<String> apiKey = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(CreateUserResponseUser other) {
      id(other.getId());
      email(other.getEmail());
      name(other.getName());
      role(other.getRole());
      accessGroups(other.getAccessGroups());
      apiKey(other.getApiKey());
      return this;
    }

    /**
     * <p>Unique identifier for the created user.</p>
     */
    @JsonSetter(
        value = "id",
        nulls = Nulls.SKIP
    )
    public Builder id(Optional<String> id) {
      this.id = id;
      return this;
    }

    public Builder id(String id) {
      this.id = Optional.ofNullable(id);
      return this;
    }

    /**
     * <p>Email address of the created user.</p>
     */
    @JsonSetter(
        value = "email",
        nulls = Nulls.SKIP
    )
    public Builder email(Optional<String> email) {
      this.email = email;
      return this;
    }

    public Builder email(String email) {
      this.email = Optional.ofNullable(email);
      return this;
    }

    /**
     * <p>Display name of the user.</p>
     */
    @JsonSetter(
        value = "name",
        nulls = Nulls.SKIP
    )
    public Builder name(Optional<String> name) {
      this.name = name;
      return this;
    }

    public Builder name(String name) {
      this.name = Optional.ofNullable(name);
      return this;
    }

    public Builder name(Nullable<String> name) {
      if (name.isNull()) {
        this.name = null;
      }
      else if (name.isEmpty()) {
        this.name = Optional.empty();
      }
      else {
        this.name = Optional.of(name.get());
      }
      return this;
    }

    /**
     * <p>Role assigned to the user.</p>
     */
    @JsonSetter(
        value = "role",
        nulls = Nulls.SKIP
    )
    public Builder role(Optional<String> role) {
      this.role = role;
      return this;
    }

    public Builder role(String role) {
      this.role = Optional.ofNullable(role);
      return this;
    }

    /**
     * <p>Access groups assigned to the user.</p>
     */
    @JsonSetter(
        value = "accessGroups",
        nulls = Nulls.SKIP
    )
    public Builder accessGroups(Optional<List<String>> accessGroups) {
      this.accessGroups = accessGroups;
      return this;
    }

    public Builder accessGroups(List<String> accessGroups) {
      this.accessGroups = Optional.ofNullable(accessGroups);
      return this;
    }

    /**
     * <p>API key generated for the user.</p>
     */
    @JsonSetter(
        value = "apiKey",
        nulls = Nulls.SKIP
    )
    public Builder apiKey(Optional<String> apiKey) {
      this.apiKey = apiKey;
      return this;
    }

    public Builder apiKey(String apiKey) {
      this.apiKey = Optional.ofNullable(apiKey);
      return this;
    }

    public Builder apiKey(Nullable<String> apiKey) {
      if (apiKey.isNull()) {
        this.apiKey = null;
      }
      else if (apiKey.isEmpty()) {
        this.apiKey = Optional.empty();
      }
      else {
        this.apiKey = Optional.of(apiKey.get());
      }
      return this;
    }

    public CreateUserResponseUser build() {
      return new CreateUserResponseUser(id, email, name, role, accessGroups, apiKey, additionalProperties);
    }
  }
}
