/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.resources.tests.rules;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.resources.tests.rules.RawRulesClient;
import com.rulebricks.resources.tests.rules.requests.CreateRulesRequest;
import com.rulebricks.resources.tests.rules.requests.DeleteRulesRequest;
import com.rulebricks.resources.tests.rules.requests.ListRulesRequest;
import com.rulebricks.types.Test;
import java.util.List;

public class RulesClient {
    protected final ClientOptions clientOptions;
    private final RawRulesClient rawClient;

    public RulesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawRulesClient(clientOptions);
    }

    public RawRulesClient withRawResponse() {
        return this.rawClient;
    }

    public List<Test> list(String slug) {
        return this.rawClient.list(slug).body();
    }

    public List<Test> list(String slug, ListRulesRequest request) {
        return this.rawClient.list(slug, request).body();
    }

    public List<Test> list(String slug, ListRulesRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(slug, request, requestOptions).body();
    }

    public Test create(String slug, CreateRulesRequest request) {
        return this.rawClient.create(slug, request).body();
    }

    public Test create(String slug, CreateRulesRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(slug, request, requestOptions).body();
    }

    public Test delete(String slug, String testId) {
        return this.rawClient.delete(slug, testId).body();
    }

    public Test delete(String slug, String testId, DeleteRulesRequest request) {
        return this.rawClient.delete(slug, testId, request).body();
    }

    public Test delete(String slug, String testId, DeleteRulesRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(slug, testId, request, requestOptions).body();
    }
}

