/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.resources.users;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.core.Suppliers;
import com.rulebricks.resources.users.RawUsersClient;
import com.rulebricks.resources.users.groups.GroupsClient;
import com.rulebricks.resources.users.requests.CreateUserRequest;
import com.rulebricks.resources.users.requests.UserInviteRequest;
import com.rulebricks.types.CreateUserResponse;
import com.rulebricks.types.UserDetail;
import com.rulebricks.types.UserInviteResponse;
import java.util.List;
import java.util.function.Supplier;

public class UsersClient {
    protected final ClientOptions clientOptions;
    private final RawUsersClient rawClient;
    protected final Supplier<GroupsClient> groupsClient;

    public UsersClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawUsersClient(clientOptions);
        this.groupsClient = Suppliers.memoize(() -> new GroupsClient(clientOptions));
    }

    public RawUsersClient withRawResponse() {
        return this.rawClient;
    }

    public UserInviteResponse invite(UserInviteRequest request) {
        return this.rawClient.invite(request).body();
    }

    public UserInviteResponse invite(UserInviteRequest request, RequestOptions requestOptions) {
        return this.rawClient.invite(request, requestOptions).body();
    }

    public List<UserDetail> list() {
        return this.rawClient.list().body();
    }

    public List<UserDetail> list(RequestOptions requestOptions) {
        return this.rawClient.list(requestOptions).body();
    }

    public CreateUserResponse create(CreateUserRequest request) {
        return this.rawClient.create(request).body();
    }

    public CreateUserResponse create(CreateUserRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).body();
    }

    public GroupsClient groups() {
        return this.groupsClient.get();
    }
}

