/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateTestRequest {
    private final String name;
    private final Map<String, Object> request;
    private final Map<String, Object> response;
    private final boolean critical;
    private final Map<String, Object> additionalProperties;

    private CreateTestRequest(String name, Map<String, Object> request, Map<String, Object> response, boolean critical, Map<String, Object> additionalProperties) {
        this.name = name;
        this.request = request;
        this.response = response;
        this.critical = critical;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="request")
    public Map<String, Object> getRequest() {
        return this.request;
    }

    @JsonProperty(value="response")
    public Map<String, Object> getResponse() {
        return this.response;
    }

    @JsonProperty(value="critical")
    public boolean getCritical() {
        return this.critical;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateTestRequest && this.equalTo((CreateTestRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateTestRequest other) {
        return this.name.equals(other.name) && this.request.equals(other.request) && this.response.equals(other.response) && this.critical == other.critical;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.request, this.response, this.critical);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    CriticalStage,
    _FinalStage {
        private String name;
        private boolean critical;
        private Map<String, Object> response = new LinkedHashMap<String, Object>();
        private Map<String, Object> request = new LinkedHashMap<String, Object>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateTestRequest other) {
            this.name(other.getName());
            this.request(other.getRequest());
            this.response(other.getResponse());
            this.critical(other.getCritical());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public CriticalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="critical")
        public _FinalStage critical(boolean critical) {
            this.critical = critical;
            return this;
        }

        @Override
        public _FinalStage response(String key, Object value) {
            this.response.put(key, value);
            return this;
        }

        @Override
        public _FinalStage putAllResponse(Map<String, Object> response) {
            if (response != null) {
                this.response.putAll(response);
            }
            return this;
        }

        @Override
        @JsonSetter(value="response", nulls=Nulls.SKIP)
        public _FinalStage response(Map<String, Object> response) {
            this.response.clear();
            if (response != null) {
                this.response.putAll(response);
            }
            return this;
        }

        @Override
        public _FinalStage request(String key, Object value) {
            this.request.put(key, value);
            return this;
        }

        @Override
        public _FinalStage putAllRequest(Map<String, Object> request) {
            if (request != null) {
                this.request.putAll(request);
            }
            return this;
        }

        @Override
        @JsonSetter(value="request", nulls=Nulls.SKIP)
        public _FinalStage request(Map<String, Object> request) {
            this.request.clear();
            if (request != null) {
                this.request.putAll(request);
            }
            return this;
        }

        @Override
        public CreateTestRequest build() {
            return new CreateTestRequest(this.name, this.request, this.response, this.critical, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateTestRequest build();

        public _FinalStage request(Map<String, Object> var1);

        public _FinalStage putAllRequest(Map<String, Object> var1);

        public _FinalStage request(String var1, Object var2);

        public _FinalStage response(Map<String, Object> var1);

        public _FinalStage putAllResponse(Map<String, Object> var1);

        public _FinalStage response(String var1, Object var2);
    }

    public static interface CriticalStage {
        public _FinalStage critical(boolean var1);
    }

    public static interface NameStage {
        public CriticalStage name(@NotNull String var1);

        public Builder from(CreateTestRequest var1);
    }
}

