/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.rules;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.resources.rules.requests.BulkSolveRulesRequest;
import com.rulebricks.resources.rules.requests.SolveRulesRequest;
import com.rulebricks.types.BulkRuleResponseItem;
import com.rulebricks.types.ParallelSolveRequestValue;
import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class AsyncRulesClient {
  protected final ClientOptions clientOptions;

  private final AsyncRawRulesClient rawClient;

  public AsyncRulesClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
    this.rawClient = new AsyncRawRulesClient(clientOptions);
  }

  /**
   * Get responses with HTTP metadata like headers
   */
  public AsyncRawRulesClient withRawResponse() {
    return this.rawClient;
  }

  /**
   * Executes a single rule identified by a unique slug. The request and response formats are dynamic, dependent on the rule configuration.
   */
  public CompletableFuture<Map<String, Object>> solve(String slug, SolveRulesRequest request) {
    return this.rawClient.solve(slug, request).thenApply(response -> response.body());
  }

  /**
   * Executes a single rule identified by a unique slug. The request and response formats are dynamic, dependent on the rule configuration.
   */
  public CompletableFuture<Map<String, Object>> solve(String slug, SolveRulesRequest request,
      RequestOptions requestOptions) {
    return this.rawClient.solve(slug, request, requestOptions).thenApply(response -> response.body());
  }

  /**
   * Executes a particular rule against multiple request data payloads provided in a list.
   */
  public CompletableFuture<List<BulkRuleResponseItem>> bulkSolve(String slug,
      BulkSolveRulesRequest request) {
    return this.rawClient.bulkSolve(slug, request).thenApply(response -> response.body());
  }

  /**
   * Executes a particular rule against multiple request data payloads provided in a list.
   */
  public CompletableFuture<List<BulkRuleResponseItem>> bulkSolve(String slug,
      BulkSolveRulesRequest request, RequestOptions requestOptions) {
    return this.rawClient.bulkSolve(slug, request, requestOptions).thenApply(response -> response.body());
  }

  /**
   * Executes multiple rules or flows in parallel based on a provided mapping of rule/flow slugs to payloads.
   */
  public CompletableFuture<Map<String, Map<String, Object>>> parallelSolve(
      Map<String, ParallelSolveRequestValue> request) {
    return this.rawClient.parallelSolve(request).thenApply(response -> response.body());
  }

  /**
   * Executes multiple rules or flows in parallel based on a provided mapping of rule/flow slugs to payloads.
   */
  public CompletableFuture<Map<String, Map<String, Object>>> parallelSolve(
      Map<String, ParallelSolveRequestValue> request, RequestOptions requestOptions) {
    return this.rawClient.parallelSolve(request, requestOptions).thenApply(response -> response.body());
  }
}
