/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.tests.rules;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.resources.tests.rules.requests.CreateRulesRequest;
import com.rulebricks.resources.tests.rules.requests.DeleteRulesRequest;
import com.rulebricks.resources.tests.rules.requests.ListRulesRequest;
import com.rulebricks.types.Test;
import java.lang.String;
import java.util.List;

public class RulesClient {
  protected final ClientOptions clientOptions;

  private final RawRulesClient rawClient;

  public RulesClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
    this.rawClient = new RawRulesClient(clientOptions);
  }

  /**
   * Get responses with HTTP metadata like headers
   */
  public RawRulesClient withRawResponse() {
    return this.rawClient;
  }

  /**
   * Retrieves a list of tests associated with the rule identified by the slug.
   */
  public List<Test> list(String slug) {
    return this.rawClient.list(slug).body();
  }

  /**
   * Retrieves a list of tests associated with the rule identified by the slug.
   */
  public List<Test> list(String slug, ListRulesRequest request) {
    return this.rawClient.list(slug, request).body();
  }

  /**
   * Retrieves a list of tests associated with the rule identified by the slug.
   */
  public List<Test> list(String slug, ListRulesRequest request, RequestOptions requestOptions) {
    return this.rawClient.list(slug, request, requestOptions).body();
  }

  /**
   * Adds a new test to the test suite of a rule identified by the slug.
   */
  public Test create(String slug, CreateRulesRequest request) {
    return this.rawClient.create(slug, request).body();
  }

  /**
   * Adds a new test to the test suite of a rule identified by the slug.
   */
  public Test create(String slug, CreateRulesRequest request, RequestOptions requestOptions) {
    return this.rawClient.create(slug, request, requestOptions).body();
  }

  /**
   * Deletes a test from the test suite of a rule identified by the slug.
   */
  public Test delete(String slug, String testId) {
    return this.rawClient.delete(slug, testId).body();
  }

  /**
   * Deletes a test from the test suite of a rule identified by the slug.
   */
  public Test delete(String slug, String testId, DeleteRulesRequest request) {
    return this.rawClient.delete(slug, testId, request).body();
  }

  /**
   * Deletes a test from the test suite of a rule identified by the slug.
   */
  public Test delete(String slug, String testId, DeleteRulesRequest request,
      RequestOptions requestOptions) {
    return this.rawClient.delete(slug, testId, request, requestOptions).body();
  }
}
