/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.users.groups;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.resources.users.groups.requests.CreateUserGroupRequest;
import com.rulebricks.types.UserGroup;
import java.util.List;

public class GroupsClient {
  protected final ClientOptions clientOptions;

  private final RawGroupsClient rawClient;

  public GroupsClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
    this.rawClient = new RawGroupsClient(clientOptions);
  }

  /**
   * Get responses with HTTP metadata like headers
   */
  public RawGroupsClient withRawResponse() {
    return this.rawClient;
  }

  /**
   * List all user groups available in your Rulebricks organization.
   */
  public List<UserGroup> list() {
    return this.rawClient.list().body();
  }

  /**
   * List all user groups available in your Rulebricks organization.
   */
  public List<UserGroup> list(RequestOptions requestOptions) {
    return this.rawClient.list(requestOptions).body();
  }

  /**
   * Create a new user group in your Rulebricks organization.
   */
  public UserGroup create(CreateUserGroupRequest request) {
    return this.rawClient.create(request).body();
  }

  /**
   * Create a new user group in your Rulebricks organization.
   */
  public UserGroup create(CreateUserGroupRequest request, RequestOptions requestOptions) {
    return this.rawClient.create(request, requestOptions).body();
  }
}
