/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.values;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.resources.values.requests.DeleteValuesRequest;
import com.rulebricks.resources.values.requests.ListValuesRequest;
import com.rulebricks.resources.values.requests.UpdateValuesRequest;
import com.rulebricks.types.DynamicValue;
import com.rulebricks.types.SuccessMessage;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AsyncValuesClient {
  protected final ClientOptions clientOptions;

  private final AsyncRawValuesClient rawClient;

  public AsyncValuesClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
    this.rawClient = new AsyncRawValuesClient(clientOptions);
  }

  /**
   * Get responses with HTTP metadata like headers
   */
  public AsyncRawValuesClient withRawResponse() {
    return this.rawClient;
  }

  /**
   * Retrieve all dynamic values for the authenticated user. Use the 'include' parameter to control whether usage information is returned.
   */
  public CompletableFuture<List<DynamicValue>> list() {
    return this.rawClient.list().thenApply(response -> response.body());
  }

  /**
   * Retrieve all dynamic values for the authenticated user. Use the 'include' parameter to control whether usage information is returned.
   */
  public CompletableFuture<List<DynamicValue>> list(ListValuesRequest request) {
    return this.rawClient.list(request).thenApply(response -> response.body());
  }

  /**
   * Retrieve all dynamic values for the authenticated user. Use the 'include' parameter to control whether usage information is returned.
   */
  public CompletableFuture<List<DynamicValue>> list(ListValuesRequest request,
      RequestOptions requestOptions) {
    return this.rawClient.list(request, requestOptions).thenApply(response -> response.body());
  }

  /**
   * Update existing dynamic values or add new ones for the authenticated user. Supports both flat and nested object structures. Nested objects are automatically flattened using dot notation and keys are converted to readable format (e.g., 'user_name' becomes 'User Name', nested 'user.contact_info.email' becomes 'User.Contact Info.Email').
   */
  public CompletableFuture<List<DynamicValue>> update(UpdateValuesRequest request) {
    return this.rawClient.update(request).thenApply(response -> response.body());
  }

  /**
   * Update existing dynamic values or add new ones for the authenticated user. Supports both flat and nested object structures. Nested objects are automatically flattened using dot notation and keys are converted to readable format (e.g., 'user_name' becomes 'User Name', nested 'user.contact_info.email' becomes 'User.Contact Info.Email').
   */
  public CompletableFuture<List<DynamicValue>> update(UpdateValuesRequest request,
      RequestOptions requestOptions) {
    return this.rawClient.update(request, requestOptions).thenApply(response -> response.body());
  }

  /**
   * Delete a specific dynamic value for the authenticated user by its ID.
   */
  public CompletableFuture<SuccessMessage> delete(DeleteValuesRequest request) {
    return this.rawClient.delete(request).thenApply(response -> response.body());
  }

  /**
   * Delete a specific dynamic value for the authenticated user by its ID.
   */
  public CompletableFuture<SuccessMessage> delete(DeleteValuesRequest request,
      RequestOptions requestOptions) {
    return this.rawClient.delete(request, requestOptions).thenApply(response -> response.body());
  }
}
