/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.resources.assets;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.core.Suppliers;
import com.rulebricks.resources.assets.AsyncRawAssetsClient;
import com.rulebricks.resources.assets.flows.AsyncFlowsClient;
import com.rulebricks.resources.assets.folders.AsyncFoldersClient;
import com.rulebricks.resources.assets.rules.AsyncRulesClient;
import com.rulebricks.types.UsageStatistics;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncAssetsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawAssetsClient rawClient;
    protected final Supplier<AsyncRulesClient> rulesClient;
    protected final Supplier<AsyncFlowsClient> flowsClient;
    protected final Supplier<AsyncFoldersClient> foldersClient;

    public AsyncAssetsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawAssetsClient(clientOptions);
        this.rulesClient = Suppliers.memoize(() -> new AsyncRulesClient(clientOptions));
        this.flowsClient = Suppliers.memoize(() -> new AsyncFlowsClient(clientOptions));
        this.foldersClient = Suppliers.memoize(() -> new AsyncFoldersClient(clientOptions));
    }

    public AsyncRawAssetsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<UsageStatistics> getUsage() {
        return this.rawClient.getUsage().thenApply(response -> (UsageStatistics)response.body());
    }

    public CompletableFuture<UsageStatistics> getUsage(RequestOptions requestOptions) {
        return this.rawClient.getUsage(requestOptions).thenApply(response -> (UsageStatistics)response.body());
    }

    public AsyncRulesClient rules() {
        return this.rulesClient.get();
    }

    public AsyncFlowsClient flows() {
        return this.flowsClient.get();
    }

    public AsyncFoldersClient folders() {
        return this.foldersClient.get();
    }
}

