/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.resources.assets.rules;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.resources.assets.rules.AsyncRawRulesClient;
import com.rulebricks.resources.assets.rules.requests.DeleteRuleRequest;
import com.rulebricks.resources.assets.rules.requests.ImportRuleRequest;
import com.rulebricks.resources.assets.rules.requests.ListRulesRequest;
import com.rulebricks.resources.assets.rules.requests.PullRulesRequest;
import com.rulebricks.types.RuleDetail;
import com.rulebricks.types.SuccessMessage;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class AsyncRulesClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawRulesClient rawClient;

    public AsyncRulesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawRulesClient(clientOptions);
    }

    public AsyncRawRulesClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<SuccessMessage> delete(DeleteRuleRequest request) {
        return this.rawClient.delete(request).thenApply(response -> (SuccessMessage)response.body());
    }

    public CompletableFuture<SuccessMessage> delete(DeleteRuleRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).thenApply(response -> (SuccessMessage)response.body());
    }

    public CompletableFuture<Map<String, Object>> pull(PullRulesRequest request) {
        return this.rawClient.pull(request).thenApply(response -> (Map)response.body());
    }

    public CompletableFuture<Map<String, Object>> pull(PullRulesRequest request, RequestOptions requestOptions) {
        return this.rawClient.pull(request, requestOptions).thenApply(response -> (Map)response.body());
    }

    public CompletableFuture<Map<String, Object>> push(ImportRuleRequest request) {
        return this.rawClient.push(request).thenApply(response -> (Map)response.body());
    }

    public CompletableFuture<Map<String, Object>> push(ImportRuleRequest request, RequestOptions requestOptions) {
        return this.rawClient.push(request, requestOptions).thenApply(response -> (Map)response.body());
    }

    public CompletableFuture<List<RuleDetail>> list() {
        return this.rawClient.list().thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<RuleDetail>> list(ListRulesRequest request) {
        return this.rawClient.list(request).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<RuleDetail>> list(ListRulesRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (List)response.body());
    }
}

