/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.resources.rules;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.resources.rules.AsyncRawRulesClient;
import com.rulebricks.resources.rules.requests.BulkSolveRulesRequest;
import com.rulebricks.resources.rules.requests.SolveRulesRequest;
import com.rulebricks.types.BulkRuleResponseItem;
import com.rulebricks.types.ParallelSolveRequestValue;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class AsyncRulesClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawRulesClient rawClient;

    public AsyncRulesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawRulesClient(clientOptions);
    }

    public AsyncRawRulesClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<Map<String, Object>> solve(String slug, SolveRulesRequest request) {
        return this.rawClient.solve(slug, request).thenApply(response -> (Map)response.body());
    }

    public CompletableFuture<Map<String, Object>> solve(String slug, SolveRulesRequest request, RequestOptions requestOptions) {
        return this.rawClient.solve(slug, request, requestOptions).thenApply(response -> (Map)response.body());
    }

    public CompletableFuture<List<BulkRuleResponseItem>> bulkSolve(String slug, BulkSolveRulesRequest request) {
        return this.rawClient.bulkSolve(slug, request).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<BulkRuleResponseItem>> bulkSolve(String slug, BulkSolveRulesRequest request, RequestOptions requestOptions) {
        return this.rawClient.bulkSolve(slug, request, requestOptions).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<Map<String, Map<String, Object>>> parallelSolve(Map<String, ParallelSolveRequestValue> request) {
        return this.rawClient.parallelSolve(request).thenApply(response -> (Map)response.body());
    }

    public CompletableFuture<Map<String, Map<String, Object>>> parallelSolve(Map<String, ParallelSolveRequestValue> request, RequestOptions requestOptions) {
        return this.rawClient.parallelSolve(request, requestOptions).thenApply(response -> (Map)response.body());
    }
}

