/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.resources.rules;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.MediaTypes;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.core.RulebricksApiApiException;
import com.rulebricks.core.RulebricksApiException;
import com.rulebricks.core.RulebricksApiHttpResponse;
import com.rulebricks.errors.BadRequestError;
import com.rulebricks.errors.InternalServerError;
import com.rulebricks.resources.rules.requests.BulkSolveRulesRequest;
import com.rulebricks.resources.rules.requests.SolveRulesRequest;
import com.rulebricks.types.BulkRuleResponseItem;
import com.rulebricks.types.ParallelSolveRequestValue;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawRulesClient {
    protected final ClientOptions clientOptions;

    public RawRulesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public RulebricksApiHttpResponse<Map<String, Object>> solve(String slug, SolveRulesRequest request) {
        return this.solve(slug, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RulebricksApiHttpResponse<Map<String, Object>> solve(String slug, SolveRulesRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("solve").addPathSegment(slug).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(request.getBody()), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new RulebricksApiException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                RulebricksApiHttpResponse<Map<String, Object>> rulebricksApiHttpResponse = new RulebricksApiHttpResponse<Map<String, Object>>((Map)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, (TypeReference)new TypeReference<Map<String, Object>>(){}), response);
                return rulebricksApiHttpResponse;
            }
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 500: {
                        throw new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                }
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response);
        }
        catch (IOException e) {
            throw new RulebricksApiException("Network error executing HTTP request", e);
        }
    }

    public RulebricksApiHttpResponse<List<BulkRuleResponseItem>> bulkSolve(String slug, BulkSolveRulesRequest request) {
        return this.bulkSolve(slug, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RulebricksApiHttpResponse<List<BulkRuleResponseItem>> bulkSolve(String slug, BulkSolveRulesRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("bulk-solve").addPathSegment(slug).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(request.getBody()), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new RulebricksApiException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                RulebricksApiHttpResponse<List<BulkRuleResponseItem>> rulebricksApiHttpResponse = new RulebricksApiHttpResponse<List<BulkRuleResponseItem>>((List)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, (TypeReference)new TypeReference<List<BulkRuleResponseItem>>(){}), response);
                return rulebricksApiHttpResponse;
            }
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 500: {
                        throw new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                }
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response);
        }
        catch (IOException e) {
            throw new RulebricksApiException("Network error executing HTTP request", e);
        }
    }

    public RulebricksApiHttpResponse<Map<String, Map<String, Object>>> parallelSolve(Map<String, ParallelSolveRequestValue> request) {
        return this.parallelSolve(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RulebricksApiHttpResponse<Map<String, Map<String, Object>>> parallelSolve(Map<String, ParallelSolveRequestValue> request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("parallel-solve").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new RulebricksApiException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                RulebricksApiHttpResponse<Map<String, Map<String, Object>>> rulebricksApiHttpResponse = new RulebricksApiHttpResponse<Map<String, Map<String, Object>>>((Map)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, (TypeReference)new TypeReference<Map<String, Map<String, Object>>>(){}), response);
                return rulebricksApiHttpResponse;
            }
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 500: {
                        throw new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                }
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response);
        }
        catch (IOException e) {
            throw new RulebricksApiException("Network error executing HTTP request", e);
        }
    }
}

