/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.types.BulkRuleResponseItemError;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

@JsonDeserialize(using=Deserializer.class)
public final class BulkRuleResponseItem {
    private final Object value;
    private final int type;

    private BulkRuleResponseItem(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((Map)this.value);
        }
        if (this.type == 1) {
            return visitor.visit((BulkRuleResponseItemError)this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BulkRuleResponseItem && this.equalTo((BulkRuleResponseItem)other);
    }

    private boolean equalTo(BulkRuleResponseItem other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }

    public static BulkRuleResponseItem of(Map<String, Object> value) {
        return new BulkRuleResponseItem(value, 0);
    }

    public static BulkRuleResponseItem of(BulkRuleResponseItemError value) {
        return new BulkRuleResponseItem(value, 1);
    }

    static final class Deserializer
    extends StdDeserializer<BulkRuleResponseItem> {
        Deserializer() {
            super(BulkRuleResponseItem.class);
        }

        public BulkRuleResponseItem deserialize(JsonParser p, DeserializationContext context) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return BulkRuleResponseItem.of((Map)ObjectMappers.JSON_MAPPER.convertValue(value, (TypeReference)new TypeReference<Map<String, Object>>(){}));
            }
            catch (RuntimeException runtimeException) {
                try {
                    return BulkRuleResponseItem.of((BulkRuleResponseItemError)ObjectMappers.JSON_MAPPER.convertValue(value, BulkRuleResponseItemError.class));
                }
                catch (RuntimeException runtimeException2) {
                    throw new JsonParseException(p, "Failed to deserialize");
                }
            }
        }
    }

    public static interface Visitor<T> {
        public T visit(Map<String, Object> var1);

        public T visit(BulkRuleResponseItemError var1);
    }
}

