/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ValueLimits {
    private final Optional<Integer> maxKeys;
    private final Optional<Integer> maxValueLength;
    private final Optional<Integer> maxTotalSize;
    private final Optional<Integer> maxKeyLength;
    private final Map<String, Object> additionalProperties;

    private ValueLimits(Optional<Integer> maxKeys, Optional<Integer> maxValueLength, Optional<Integer> maxTotalSize, Optional<Integer> maxKeyLength, Map<String, Object> additionalProperties) {
        this.maxKeys = maxKeys;
        this.maxValueLength = maxValueLength;
        this.maxTotalSize = maxTotalSize;
        this.maxKeyLength = maxKeyLength;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="MAX_KEYS")
    public Optional<Integer> getMaxKeys() {
        return this.maxKeys;
    }

    @JsonProperty(value="MAX_VALUE_LENGTH")
    public Optional<Integer> getMaxValueLength() {
        return this.maxValueLength;
    }

    @JsonProperty(value="MAX_TOTAL_SIZE")
    public Optional<Integer> getMaxTotalSize() {
        return this.maxTotalSize;
    }

    @JsonProperty(value="MAX_KEY_LENGTH")
    public Optional<Integer> getMaxKeyLength() {
        return this.maxKeyLength;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ValueLimits && this.equalTo((ValueLimits)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ValueLimits other) {
        return this.maxKeys.equals(other.maxKeys) && this.maxValueLength.equals(other.maxValueLength) && this.maxTotalSize.equals(other.maxTotalSize) && this.maxKeyLength.equals(other.maxKeyLength);
    }

    public int hashCode() {
        return Objects.hash(this.maxKeys, this.maxValueLength, this.maxTotalSize, this.maxKeyLength);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Integer> maxKeys = Optional.empty();
        private Optional<Integer> maxValueLength = Optional.empty();
        private Optional<Integer> maxTotalSize = Optional.empty();
        private Optional<Integer> maxKeyLength = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ValueLimits other) {
            this.maxKeys(other.getMaxKeys());
            this.maxValueLength(other.getMaxValueLength());
            this.maxTotalSize(other.getMaxTotalSize());
            this.maxKeyLength(other.getMaxKeyLength());
            return this;
        }

        @JsonSetter(value="MAX_KEYS", nulls=Nulls.SKIP)
        public Builder maxKeys(Optional<Integer> maxKeys) {
            this.maxKeys = maxKeys;
            return this;
        }

        public Builder maxKeys(Integer maxKeys) {
            this.maxKeys = Optional.ofNullable(maxKeys);
            return this;
        }

        @JsonSetter(value="MAX_VALUE_LENGTH", nulls=Nulls.SKIP)
        public Builder maxValueLength(Optional<Integer> maxValueLength) {
            this.maxValueLength = maxValueLength;
            return this;
        }

        public Builder maxValueLength(Integer maxValueLength) {
            this.maxValueLength = Optional.ofNullable(maxValueLength);
            return this;
        }

        @JsonSetter(value="MAX_TOTAL_SIZE", nulls=Nulls.SKIP)
        public Builder maxTotalSize(Optional<Integer> maxTotalSize) {
            this.maxTotalSize = maxTotalSize;
            return this;
        }

        public Builder maxTotalSize(Integer maxTotalSize) {
            this.maxTotalSize = Optional.ofNullable(maxTotalSize);
            return this;
        }

        @JsonSetter(value="MAX_KEY_LENGTH", nulls=Nulls.SKIP)
        public Builder maxKeyLength(Optional<Integer> maxKeyLength) {
            this.maxKeyLength = maxKeyLength;
            return this;
        }

        public Builder maxKeyLength(Integer maxKeyLength) {
            this.maxKeyLength = Optional.ofNullable(maxKeyLength);
            return this;
        }

        public ValueLimits build() {
            return new ValueLimits(this.maxKeys, this.maxValueLength, this.maxTotalSize, this.maxKeyLength, this.additionalProperties);
        }
    }
}

