/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.Environment;
import java.lang.Integer;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import okhttp3.OkHttpClient;

public class RulebricksApiClientBuilder {
  private Optional<Integer> timeout = Optional.empty();

  private Optional<Integer> maxRetries = Optional.empty();

  private final Map<String, String> customHeaders = new HashMap<>();

  private String apiKey = null;

  private Environment environment = Environment.DEFAULT;

  private OkHttpClient httpClient;

  /**
   * Sets apiKey
   */
  public RulebricksApiClientBuilder apiKey(String apiKey) {
    this.apiKey = apiKey;
    return this;
  }

  public RulebricksApiClientBuilder environment(Environment environment) {
    this.environment = environment;
    return this;
  }

  public RulebricksApiClientBuilder url(String url) {
    this.environment = Environment.custom(url);
    return this;
  }

  /**
   * Sets the timeout (in seconds) for the client. Defaults to 60 seconds.
   */
  public RulebricksApiClientBuilder timeout(int timeout) {
    this.timeout = Optional.of(timeout);
    return this;
  }

  /**
   * Sets the maximum number of retries for the client. Defaults to 2 retries.
   */
  public RulebricksApiClientBuilder maxRetries(int maxRetries) {
    this.maxRetries = Optional.of(maxRetries);
    return this;
  }

  /**
   * Sets the underlying OkHttp client
   */
  public RulebricksApiClientBuilder httpClient(OkHttpClient httpClient) {
    this.httpClient = httpClient;
    return this;
  }

  /**
   * Add a custom header to be sent with all requests.
   * For headers that need to be computed dynamically or conditionally, use the setAdditional() method override instead.
   *
   * @param name The header name
   * @param value The header value
   * @return This builder for method chaining
   */
  public RulebricksApiClientBuilder addHeader(String name, String value) {
    this.customHeaders.put(name, value);
    return this;
  }

  protected ClientOptions buildClientOptions() {
    ClientOptions.Builder builder = ClientOptions.builder();
    setEnvironment(builder);
    setAuthentication(builder);
    setHttpClient(builder);
    setTimeouts(builder);
    setRetries(builder);
    for (Map.Entry<String, String> header : this.customHeaders.entrySet()) {
      builder.addHeader(header.getKey(), header.getValue());
    }
    setAdditional(builder);
    return builder.build();
  }

  /**
   * Sets the environment configuration for the client.
   * Override this method to modify URLs or add environment-specific logic.
   *
   * @param builder The ClientOptions.Builder to configure
   */
  protected void setEnvironment(ClientOptions.Builder builder) {
    builder.environment(this.environment);
  }

  /**
   * Override this method to customize authentication.
   * This method is called during client options construction to set up authentication headers.
   *
   * @param builder The ClientOptions.Builder to configure
   *
   * Example:
   * <pre>{@code
   * &#64;Override
   * protected void setAuthentication(ClientOptions.Builder builder) {
   *     super.setAuthentication(builder); // Keep existing auth
   *     builder.addHeader("X-API-Key", this.apiKey);
   * }
   * }</pre>
   */
  protected void setAuthentication(ClientOptions.Builder builder) {
    builder.addHeader("x-api-key", this.apiKey);
  }

  /**
   * Sets the request timeout configuration.
   * Override this method to customize timeout behavior.
   *
   * @param builder The ClientOptions.Builder to configure
   */
  protected void setTimeouts(ClientOptions.Builder builder) {
    if (this.timeout.isPresent()) {
      builder.timeout(this.timeout.get());
    }
  }

  /**
   * Sets the retry configuration for failed requests.
   * Override this method to implement custom retry strategies.
   *
   * @param builder The ClientOptions.Builder to configure
   */
  protected void setRetries(ClientOptions.Builder builder) {
    if (this.maxRetries.isPresent()) {
      builder.maxRetries(this.maxRetries.get());
    }
  }

  /**
   * Sets the OkHttp client configuration.
   * Override this method to customize HTTP client behavior (interceptors, connection pools, etc).
   *
   * @param builder The ClientOptions.Builder to configure
   */
  protected void setHttpClient(ClientOptions.Builder builder) {
    if (this.httpClient != null) {
      builder.httpClient(this.httpClient);
    }
  }

  /**
   * Override this method to add any additional configuration to the client.
   * This method is called at the end of the configuration chain, allowing you to add
   * custom headers, modify settings, or perform any other client customization.
   *
   * @param builder The ClientOptions.Builder to configure
   *
   * Example:
   * <pre>{@code
   * &#64;Override
   * protected void setAdditional(ClientOptions.Builder builder) {
   *     builder.addHeader("X-Request-ID", () -&gt; UUID.randomUUID().toString());
   *     builder.addHeader("X-Client-Version", "1.0.0");
   * }
   * }</pre>
   */
  protected void setAdditional(ClientOptions.Builder builder) {
  }

  /**
   * Override this method to add custom validation logic before the client is built.
   * This method is called at the beginning of the build() method to ensure the configuration is valid.
   * Throw an exception to prevent client creation if validation fails.
   *
   * Example:
   * <pre>{@code
   * &#64;Override
   * protected void validateConfiguration() {
   *     super.validateConfiguration(); // Run parent validations
   *     if (tenantId == null || tenantId.isEmpty()) {
   *         throw new IllegalStateException("tenantId is required");
   *     }
   * }
   * }</pre>
   */
  protected void validateConfiguration() {
  }

  public RulebricksApiClient build() {
    if (apiKey == null) {
      throw new RuntimeException("Please provide apiKey");
    }
    validateConfiguration();
    return new RulebricksApiClient(buildClientOptions());
  }
}
