/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.assets;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.core.Suppliers;
import com.rulebricks.resources.assets.flows.FlowsClient;
import com.rulebricks.resources.assets.folders.FoldersClient;
import com.rulebricks.resources.assets.requests.ExportManifestRequest;
import com.rulebricks.resources.assets.requests.ImportManifestRequest;
import com.rulebricks.resources.assets.rules.RulesClient;
import com.rulebricks.resources.assets.types.ExportAssetsResponse;
import com.rulebricks.types.ImportManifestResponse;
import com.rulebricks.types.UsageStatistics;
import java.util.function.Supplier;

public class AssetsClient {
  protected final ClientOptions clientOptions;

  private final RawAssetsClient rawClient;

  protected final Supplier<RulesClient> rulesClient;

  protected final Supplier<FlowsClient> flowsClient;

  protected final Supplier<FoldersClient> foldersClient;

  public AssetsClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
    this.rawClient = new RawAssetsClient(clientOptions);
    this.rulesClient = Suppliers.memoize(() -> new RulesClient(clientOptions));
    this.flowsClient = Suppliers.memoize(() -> new FlowsClient(clientOptions));
    this.foldersClient = Suppliers.memoize(() -> new FoldersClient(clientOptions));
  }

  /**
   * Get responses with HTTP metadata like headers
   */
  public RawAssetsClient withRawResponse() {
    return this.rawClient;
  }

  /**
   * Get the rule execution usage of your organization.
   */
  public UsageStatistics getUsage() {
    return this.rawClient.getUsage().body();
  }

  /**
   * Get the rule execution usage of your organization.
   */
  public UsageStatistics getUsage(RequestOptions requestOptions) {
    return this.rawClient.getUsage(requestOptions).body();
  }

  /**
   * Import rules, flows, contexts, and values from an RBM manifest file.
   */
  public ImportManifestResponse import_(ImportManifestRequest request) {
    return this.rawClient.import_(request).body();
  }

  /**
   * Import rules, flows, contexts, and values from an RBM manifest file.
   */
  public ImportManifestResponse import_(ImportManifestRequest request,
      RequestOptions requestOptions) {
    return this.rawClient.import_(request, requestOptions).body();
  }

  /**
   * Export selected rules, flows, contexts, and values to an RBM manifest file.
   */
  public ExportAssetsResponse export() {
    return this.rawClient.export().body();
  }

  /**
   * Export selected rules, flows, contexts, and values to an RBM manifest file.
   */
  public ExportAssetsResponse export(ExportManifestRequest request) {
    return this.rawClient.export(request).body();
  }

  /**
   * Export selected rules, flows, contexts, and values to an RBM manifest file.
   */
  public ExportAssetsResponse export(ExportManifestRequest request, RequestOptions requestOptions) {
    return this.rawClient.export(request, requestOptions).body();
  }

  public RulesClient rules() {
    return this.rulesClient.get();
  }

  public FlowsClient flows() {
    return this.flowsClient.get();
  }

  public FoldersClient folders() {
    return this.foldersClient.get();
  }
}
