/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.assets;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.MediaTypes;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.core.RulebricksApiApiException;
import com.rulebricks.core.RulebricksApiException;
import com.rulebricks.core.RulebricksApiHttpResponse;
import com.rulebricks.errors.BadRequestError;
import com.rulebricks.errors.InternalServerError;
import com.rulebricks.resources.assets.requests.ExportManifestRequest;
import com.rulebricks.resources.assets.requests.ImportManifestRequest;
import com.rulebricks.resources.assets.types.ExportAssetsResponse;
import com.rulebricks.types.ImportManifestResponse;
import com.rulebricks.types.UsageStatistics;
import java.io.IOException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class AsyncRawAssetsClient {
  protected final ClientOptions clientOptions;

  public AsyncRawAssetsClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
  }

  /**
   * Get the rule execution usage of your organization.
   */
  public CompletableFuture<RulebricksApiHttpResponse<UsageStatistics>> getUsage() {
    return getUsage(null);
  }

  /**
   * Get the rule execution usage of your organization.
   */
  public CompletableFuture<RulebricksApiHttpResponse<UsageStatistics>> getUsage(
      RequestOptions requestOptions) {
    HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

      .addPathSegments("admin/usage")
      .build();
    Request okhttpRequest = new Request.Builder()
      .url(httpUrl)
      .method("GET", null)
      .headers(Headers.of(clientOptions.headers(requestOptions)))
      .addHeader("Accept", "application/json")
      .build();
    OkHttpClient client = clientOptions.httpClient();
    if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
      client = clientOptions.httpClientWithTimeout(requestOptions);
    }
    CompletableFuture<RulebricksApiHttpResponse<UsageStatistics>> future = new CompletableFuture<>();
    client.newCall(okhttpRequest).enqueue(new Callback() {
      @Override
      public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
        try (ResponseBody responseBody = response.body()) {
          String responseBodyString = responseBody != null ? responseBody.string() : "{}";
          if (response.isSuccessful()) {
            future.complete(new RulebricksApiHttpResponse<>(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, UsageStatistics.class), response));
            return;
          }
          Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
          future.completeExceptionally(new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response));
          return;
        }
        catch (IOException e) {
          future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
        }
      }

      @Override
      public void onFailure(@NotNull Call call, @NotNull IOException e) {
        future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
      }
    });
    return future;
  }

  /**
   * Import rules, flows, contexts, and values from an RBM manifest file.
   */
  public CompletableFuture<RulebricksApiHttpResponse<ImportManifestResponse>> import_(
      ImportManifestRequest request) {
    return import_(request,null);
  }

  /**
   * Import rules, flows, contexts, and values from an RBM manifest file.
   */
  public CompletableFuture<RulebricksApiHttpResponse<ImportManifestResponse>> import_(
      ImportManifestRequest request, RequestOptions requestOptions) {
    HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

      .addPathSegments("admin/import")
      .build();
    RequestBody body;
    try {
      body = RequestBody.create(ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
    }
    catch(JsonProcessingException e) {
      throw new RulebricksApiException("Failed to serialize request", e);
    }
    Request okhttpRequest = new Request.Builder()
      .url(httpUrl)
      .method("POST", body)
      .headers(Headers.of(clientOptions.headers(requestOptions)))
      .addHeader("Content-Type", "application/json")
      .addHeader("Accept", "application/json")
      .build();
    OkHttpClient client = clientOptions.httpClient();
    if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
      client = clientOptions.httpClientWithTimeout(requestOptions);
    }
    CompletableFuture<RulebricksApiHttpResponse<ImportManifestResponse>> future = new CompletableFuture<>();
    client.newCall(okhttpRequest).enqueue(new Callback() {
      @Override
      public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
        try (ResponseBody responseBody = response.body()) {
          String responseBodyString = responseBody != null ? responseBody.string() : "{}";
          if (response.isSuccessful()) {
            future.complete(new RulebricksApiHttpResponse<>(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ImportManifestResponse.class), response));
            return;
          }
          try {
            switch (response.code()) {
              case 400:future.completeExceptionally(new BadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
              return;
              case 500:future.completeExceptionally(new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
              return;
            }
          }
          catch (JsonProcessingException ignored) {
            // unable to map error response, throwing generic error
          }
          Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
          future.completeExceptionally(new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response));
          return;
        }
        catch (IOException e) {
          future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
        }
      }

      @Override
      public void onFailure(@NotNull Call call, @NotNull IOException e) {
        future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
      }
    });
    return future;
  }

  /**
   * Export selected rules, flows, contexts, and values to an RBM manifest file.
   */
  public CompletableFuture<RulebricksApiHttpResponse<ExportAssetsResponse>> export() {
    return export(ExportManifestRequest.builder().build());
  }

  /**
   * Export selected rules, flows, contexts, and values to an RBM manifest file.
   */
  public CompletableFuture<RulebricksApiHttpResponse<ExportAssetsResponse>> export(
      ExportManifestRequest request) {
    return export(request,null);
  }

  /**
   * Export selected rules, flows, contexts, and values to an RBM manifest file.
   */
  public CompletableFuture<RulebricksApiHttpResponse<ExportAssetsResponse>> export(
      ExportManifestRequest request, RequestOptions requestOptions) {
    HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

      .addPathSegments("admin/export")
      .build();
    RequestBody body;
    try {
      body = RequestBody.create(ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
    }
    catch(JsonProcessingException e) {
      throw new RulebricksApiException("Failed to serialize request", e);
    }
    Request okhttpRequest = new Request.Builder()
      .url(httpUrl)
      .method("POST", body)
      .headers(Headers.of(clientOptions.headers(requestOptions)))
      .addHeader("Content-Type", "application/json")
      .addHeader("Accept", "application/json")
      .build();
    OkHttpClient client = clientOptions.httpClient();
    if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
      client = clientOptions.httpClientWithTimeout(requestOptions);
    }
    CompletableFuture<RulebricksApiHttpResponse<ExportAssetsResponse>> future = new CompletableFuture<>();
    client.newCall(okhttpRequest).enqueue(new Callback() {
      @Override
      public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
        try (ResponseBody responseBody = response.body()) {
          String responseBodyString = responseBody != null ? responseBody.string() : "{}";
          if (response.isSuccessful()) {
            future.complete(new RulebricksApiHttpResponse<>(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ExportAssetsResponse.class), response));
            return;
          }
          try {
            switch (response.code()) {
              case 400:future.completeExceptionally(new BadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
              return;
              case 500:future.completeExceptionally(new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
              return;
            }
          }
          catch (JsonProcessingException ignored) {
            // unable to map error response, throwing generic error
          }
          Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
          future.completeExceptionally(new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response));
          return;
        }
        catch (IOException e) {
          future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
        }
      }

      @Override
      public void onFailure(@NotNull Call call, @NotNull IOException e) {
        future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
      }
    });
    return future;
  }
}
